/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.BeanInject;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BindToRegistryBeanPostProcessorTest
extends ContextTestSupport {
    @BindToRegistry(beanPostProcess=true)
    private final FooService foo = new FooService();

    @BindToRegistry(beanPostProcess=true)
    public FooService myOtherFoo() {
        return new FooService();
    }

    @Test
    public void testPostProcessor() throws Exception {
        CamelBeanPostProcessor cbpp = PluginHelper.getBeanPostProcessor((CamelContext)this.context);
        cbpp.postProcessBeforeInitialization((Object)this, "this");
        cbpp.postProcessAfterInitialization((Object)this, "this");
        Assertions.assertNotNull((Object)this.foo);
        Assertions.assertSame((Object)this.context, (Object)this.foo.getCamelContext());
        FooService other = (FooService)this.context.getRegistry().lookupByName("myOtherFoo");
        Assertions.assertNotNull((Object)other);
        Assertions.assertSame((Object)this.context, (Object)other.getCamelContext());
    }

    public static class FooService {
        @BeanInject
        private CamelContext camelContext;

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }
    }
}

