/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BindToRegistryBeanLazyMethodTest
extends ContextTestSupport {
    private String hello = "Hello World";

    @BindToRegistry(lazy=false)
    public FooService myEager() {
        return new FooService(this.hello);
    }

    @BindToRegistry(lazy=true)
    public FooService myLazy() {
        return new FooService(this.hello);
    }

    @Test
    public void testLazy() throws Exception {
        CamelBeanPostProcessor cbpp = PluginHelper.getBeanPostProcessor((CamelContext)this.context);
        cbpp.postProcessBeforeInitialization((Object)this, "this");
        cbpp.postProcessAfterInitialization((Object)this, "this");
        this.hello = "Bye World";
        FooService eager = (FooService)this.context.getRegistry().lookupByNameAndType("myEager", FooService.class);
        Assertions.assertNotNull((Object)eager);
        Assertions.assertEquals((Object)"Hello World", (Object)eager.getMessage());
        FooService lazy = (FooService)this.context.getRegistry().lookupByNameAndType("myLazy", FooService.class);
        Assertions.assertNotNull((Object)lazy);
        Assertions.assertEquals((Object)"Bye World", (Object)lazy.getMessage());
    }

    public static class FooService {
        private final String message;

        public FooService(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

