/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BindToRegistryBeanInitDestroyMethodTest
extends ContextTestSupport {
    @BindToRegistry(initMethod="start", destroyMethod="stop")
    public FooService myFoo() {
        return new FooService("World");
    }

    @Test
    public void testStop() throws Exception {
        CamelBeanPostProcessor cbpp = PluginHelper.getBeanPostProcessor((CamelContext)this.context);
        cbpp.postProcessBeforeInitialization((Object)this, "this");
        cbpp.postProcessAfterInitialization((Object)this, "this");
        FooService foo = (FooService)this.context.getRegistry().lookupByNameAndType("myFoo", FooService.class);
        Assertions.assertNotNull((Object)foo);
        Assertions.assertEquals((Object)"Started World", (Object)foo.getMessage());
        this.context.stop();
        Assertions.assertEquals((Object)"Stopped", (Object)foo.getMessage());
    }

    @Test
    public void testUnbind() throws Exception {
        CamelBeanPostProcessor cbpp = PluginHelper.getBeanPostProcessor((CamelContext)this.context);
        cbpp.postProcessBeforeInitialization((Object)this, "this");
        cbpp.postProcessAfterInitialization((Object)this, "this");
        FooService foo = (FooService)this.context.getRegistry().lookupByNameAndType("myFoo", FooService.class);
        Assertions.assertNotNull((Object)foo);
        Assertions.assertEquals((Object)"Started World", (Object)foo.getMessage());
        this.context.getRegistry().unbind("myFoo");
        Assertions.assertEquals((Object)"Stopped", (Object)foo.getMessage());
    }

    public static class FooService {
        private String message;

        public FooService(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void start() {
            this.message = "Started " + this.message;
        }

        public void stop() {
            this.message = "Stopped";
        }
    }
}

