/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Service;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BindToRegistryBeanInitDestroyMethodServiceTest
extends ContextTestSupport {
    @BindToRegistry
    public FooService myFoo() {
        return new FooService("World");
    }

    @Test
    public void testStop() throws Exception {
        Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory((CamelContext)this.context).createBindToRegistryFactory("myFoo", (Object)this.myFoo(), FooService.class, "myFoo", false, "start", "stop");
        task.run();
        FooService foo = (FooService)this.context.getRegistry().lookupByNameAndType("myFoo", FooService.class);
        Assertions.assertNotNull((Object)foo);
        Assertions.assertEquals((Object)"Started World", (Object)foo.getMessage());
        this.context.stop();
        Assertions.assertEquals((Object)"Stopped", (Object)foo.getMessage());
    }

    @Test
    public void testUnbind() throws Exception {
        Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory((CamelContext)this.context).createBindToRegistryFactory("myFoo", (Object)this.myFoo(), FooService.class, "myFoo", false, "start", "stop");
        task.run();
        FooService foo = (FooService)this.context.getRegistry().lookupByNameAndType("myFoo", FooService.class);
        Assertions.assertNotNull((Object)foo);
        Assertions.assertEquals((Object)"Started World", (Object)foo.getMessage());
        this.context.getRegistry().unbind("myFoo");
        Assertions.assertEquals((Object)"Stopped", (Object)foo.getMessage());
    }

    public static class FooService
    implements Service {
        private String message;

        public FooService(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void start() {
            this.message = "Started " + this.message;
        }

        public void stop() {
            this.message = "Stopped";
        }
    }
}

