/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.FooBar;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Test;

public class BeanInjectRouteBuilderTest
extends ContextTestSupport {
    @BeanInject
    private FooBar foo;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("foo", (Object)new FooBar());
        return registry;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        CamelBeanPostProcessor post = PluginHelper.getBeanPostProcessor((CamelContext)context);
        post.postProcessBeforeInitialization((Object)this, "MyRoute");
        post.postProcessAfterInitialization((Object)this, "MyRoute");
        return context;
    }

    @Test
    public void testBeanInject() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        String out = BeanInjectRouteBuilderTest.this.foo.hello((String)exchange.getIn().getBody(String.class));
                        exchange.getIn().setBody((Object)out);
                    }
                })).to("mock:result");
            }
        };
    }
}

