/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Test;

public class BeanInjectProducerTemplateTest
extends ContextTestSupport {
    @BeanInject
    private FluentProducerTemplate fluent;

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        CamelBeanPostProcessor post = PluginHelper.getBeanPostProcessor((CamelContext)context);
        post.postProcessBeforeInitialization((Object)this, "BeanInjectProducerTemplateTest");
        post.postProcessAfterInitialization((Object)this, "BeanInjectProducerTemplateTest");
        return context;
    }

    @Test
    public void testBeanInjectTemplate() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.fluent.withBody((Object)"Hello World").to("direct:start").send();
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

