/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.xml.StreamSourceCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StreamSourceCacheTest
extends ContextTestSupport {
    @Test
    public void testStreamSourceCache() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        StreamSource source = (StreamSource)this.context.getTypeConverter().convertTo(StreamSource.class, (Object)"<foo>bar</foo>");
        StreamSourceCache cache = new StreamSourceCache(source, (Exchange)exchange);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        cache.writeTo((OutputStream)bos);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)bos);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)s);
    }

    @Test
    public void testStreamSourceCacheIsEmpty() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        StreamSource source = (StreamSource)this.context.getTypeConverter().convertTo(StreamSource.class, (Object)"");
        StreamSourceCache cache = new StreamSourceCache(source, (Exchange)exchange);
        Assertions.assertTrue((boolean)cache.isEmpty());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        cache.writeTo((OutputStream)bos);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)bos);
        Assertions.assertEquals((Object)"", (Object)s);
        source = (StreamSource)this.context.getTypeConverter().convertTo(StreamSource.class, (Object)"<foo>bar</foo>");
        cache = new StreamSourceCache(source, (Exchange)exchange);
        Assertions.assertFalse((boolean)cache.isEmpty());
        bos = new ByteArrayOutputStream();
        cache.writeTo((OutputStream)bos);
        s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)bos);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)s);
    }
}

