/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.converter.stream.StreamCacheConverter;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.xml.StreamSourceConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.InputSource;

public class StreamCacheConverterTest
extends ContextTestSupport {
    private static final String TEST_FILE = "org/apache/camel/converter/stream/test.xml";
    private static final String MESSAGE = "<test>This is a test</test>";
    private Exchange exchange;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.exchange = new DefaultExchange((CamelContext)this.context);
    }

    @Test
    public void testConvertToStreamCache() {
        this.context.start();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(MESSAGE.getBytes());
        StreamCache streamCache = StreamSourceConverter.convertToStreamCache((SAXSource)new SAXSource(new InputSource(inputStream)), (Exchange)this.exchange);
        String message = (String)this.exchange.getContext().getTypeConverter().convertTo(String.class, (Object)streamCache);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)MESSAGE, (Object)message, (String)"The converted message is wrong");
    }

    @Test
    public void testConvertToStreamCacheStreamSource() throws Exception {
        this.context.start();
        StreamSource source = new StreamSource(this.getTestFileStream());
        StreamCache cache = StreamSourceConverter.convertToStreamCache((StreamSource)source, (Exchange)this.exchange);
        XmlConverter converter = new XmlConverter();
        Assertions.assertNotNull((Object)converter.toString((Source)cache, null));
        cache.reset();
        Assertions.assertNotNull((Object)converter.toString((Source)cache, null));
    }

    @Test
    public void testConvertToStreamCacheInputStream() throws Exception {
        this.context.start();
        InputStream is = this.getTestFileStream();
        InputStream cache = (InputStream)StreamCacheConverter.convertToStreamCache((InputStream)is, (Exchange)this.exchange);
        String data = IOConverter.toString((InputStream)cache, null);
        cache.reset();
        String data2 = IOConverter.toString((InputStream)cache, null);
        Assertions.assertEquals((Object)data, (Object)data2);
    }

    @Test
    public void testConvertToStreamCacheInputStreamWithFileCache() throws Exception {
        this.exchange.getContext().getStreamCachingStrategy().setSpoolThreshold(1L);
        this.context.start();
        InputStream is = this.getTestFileStream();
        InputStream cache = (InputStream)StreamCacheConverter.convertToStreamCache((InputStream)is, (Exchange)this.exchange);
        Assertions.assertNotNull((Object)IOConverter.toString((InputStream)cache, null));
        Assertions.assertThrows(Exception.class, () -> {
            cache.reset();
            this.exchange.getUnitOfWork().done(this.exchange);
        }, (String)"We except the exception here");
    }

    @Test
    public void testConvertToSerializable() throws Exception {
        this.context.start();
        InputStream is = this.getTestFileStream();
        StreamCache cache = StreamCacheConverter.convertToStreamCache((InputStream)is, (Exchange)this.exchange);
        Serializable ser = StreamSourceConverter.convertToSerializable((StreamCache)cache, (Exchange)this.exchange);
        Assertions.assertNotNull((Object)ser);
    }

    @Test
    public void testConvertToByteArray() throws Exception {
        this.context.start();
        InputStream is = this.getTestFileStream();
        StreamCache cache = StreamCacheConverter.convertToStreamCache((InputStream)is, (Exchange)this.exchange);
        byte[] bytes = StreamCacheConverter.convertToByteArray((StreamCache)cache, (Exchange)this.exchange);
        Assertions.assertNotNull((Object)bytes);
    }

    protected InputStream getTestFileStream() {
        InputStream answer = this.getClass().getClassLoader().getResourceAsStream(TEST_FILE);
        Assertions.assertNotNull((Object)answer, (String)"Should have found the file: org/apache/camel/converter/stream/test.xml on the classpath");
        return answer;
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

