/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.FileInputStreamCache;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.impl.engine.DefaultUnitOfWork;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.IOHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CachedOutputStreamTest
extends ContextTestSupport {
    private static final String TEST_STRING = "This is a test string and it has enough aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa ";
    private Exchange exchange;

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setStreamCaching(Boolean.valueOf(true));
        context.getStreamCachingStrategy().setSpoolDirectory(this.testDirectory().toFile());
        context.getStreamCachingStrategy().setSpoolEnabled(true);
        context.getStreamCachingStrategy().setSpoolThreshold(16L);
        return context;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.exchange = new DefaultExchange((CamelContext)this.context);
        DefaultUnitOfWork uow = new DefaultUnitOfWork(this.exchange);
        this.exchange.getExchangeExtension().setUnitOfWork((UnitOfWork)uow);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private static String toString(InputStream input) throws IOException {
        BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(input));
        StringJoiner builder = new StringJoiner(", ");
        String line;
        while ((line = reader.readLine()) != null) {
            builder.add(line);
        }
        return builder.toString();
    }

    @Test
    public void testCachedStreamAccessStreamWhenExchangeOnCompletion() throws Exception {
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange, false);
        cos.write(TEST_STRING.getBytes(StandardCharsets.UTF_8));
        File file = this.testDirectory().toFile();
        String[] files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)1, (int)files.length, (String)"we should have a temp file");
        Assertions.assertTrue((boolean)files[0].startsWith("cos"), (String)"The file name should start with cos");
        InputStream is = cos.getWrappedInputStream();
        this.exchange.getUnitOfWork().done(this.exchange);
        String temp = CachedOutputStreamTest.toString(is);
        Assertions.assertEquals((Object)TEST_STRING, (Object)temp, (String)"Get a wrong stream content");
        IOHelper.close((Closeable)is);
        files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)0, (int)files.length, (String)"we should have a temp file");
        IOHelper.close((Closeable)cos);
    }

    @Test
    public void testCacheStreamToFileAndCloseStream() throws Exception {
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes(StandardCharsets.UTF_8));
        File file = this.testDirectory().toFile();
        String[] files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)1, (int)files.length, (String)"we should have a temp file");
        Assertions.assertTrue((boolean)files[0].startsWith("cos"), (String)"The file name should start with cos");
        StreamCache cache = cos.newStreamCache();
        boolean b = cache instanceof FileInputStreamCache;
        Assertions.assertTrue((boolean)b, (String)"Should get the FileInputStreamCache");
        String temp = CachedOutputStreamTest.toString((InputStream)cache);
        ((InputStream)cache).close();
        files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)1, (int)files.length, (String)"we should have a temp file");
        Assertions.assertEquals((Object)TEST_STRING, (Object)temp, (String)"Cached a wrong file");
        this.exchange.getUnitOfWork().done(this.exchange);
        Assertions.assertThrows(Exception.class, () -> ((StreamCache)cache).reset(), (String)"we expect the exception here");
        files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)0, (int)files.length, (String)"we should have no temp file");
        IOHelper.close((Closeable)cos);
    }

    @Test
    public void testCacheStreamToFileAndCloseStreamEncrypted() throws Exception {
        this.context.getStreamCachingStrategy().setSpoolCipher("RC4");
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes(StandardCharsets.UTF_8));
        cos.flush();
        File file = this.testDirectory().toFile();
        String[] files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)1, (int)files.length, (String)"we should have a temp file");
        Assertions.assertTrue((new File(file, files[0]).length() > 10L ? 1 : 0) != 0, (String)"The content is written");
        FileInputStream tmpin = new FileInputStream(new File(file, files[0]));
        String temp = CachedOutputStreamTest.toString(tmpin);
        Assertions.assertTrue((!temp.isEmpty() && !temp.contains("aaa") ? 1 : 0) != 0, (String)"The content is not encrypted");
        tmpin.close();
        StreamCache cache = cos.newStreamCache();
        boolean b = cache instanceof FileInputStreamCache;
        Assertions.assertTrue((boolean)b, (String)"Should get the FileInputStreamCache");
        temp = CachedOutputStreamTest.toString((InputStream)cache);
        ((InputStream)cache).close();
        Assertions.assertEquals((int)1, (int)files.length, (String)"we should have a temp file");
        Assertions.assertEquals((Object)TEST_STRING, (Object)temp, (String)"Cached a wrong file");
        this.exchange.getUnitOfWork().done(this.exchange);
        Assertions.assertThrows(Exception.class, () -> ((StreamCache)cache).reset(), (String)"We expect the exception here");
        files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)0, (int)files.length, (String)"we should have no temp file");
        IOHelper.close((Closeable)cos);
    }

    @Test
    public void testCacheStreamToFileCloseStreamBeforeDone() throws Exception {
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes(StandardCharsets.UTF_8));
        File file = this.testDirectory().toFile();
        String[] files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)1, (int)files.length, (String)"we should have a temp file");
        Assertions.assertTrue((boolean)files[0].startsWith("cos"), (String)"The file name should start with cos");
        StreamCache cache = cos.newStreamCache();
        boolean b = cache instanceof FileInputStreamCache;
        Assertions.assertTrue((boolean)b, (String)"Should get the FileInputStreamCache");
        String temp = CachedOutputStreamTest.toString((InputStream)cache);
        Assertions.assertEquals((Object)TEST_STRING, (Object)temp, (String)"Cached a wrong file");
        cache.reset();
        temp = CachedOutputStreamTest.toString((InputStream)cache);
        Assertions.assertEquals((Object)TEST_STRING, (Object)temp, (String)"Cached a wrong file");
        ((InputStream)cache).close();
        files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)1, (int)files.length, (String)"we should have a temp file");
        this.exchange.getUnitOfWork().done(this.exchange);
        files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)0, (int)files.length, (String)"we should have no temp file");
        IOHelper.close((Closeable)cos);
    }

    @Test
    public void testCacheStreamToMemory() throws Exception {
        this.context.getStreamCachingStrategy().setSpoolThreshold(1024L);
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes(StandardCharsets.UTF_8));
        File file = this.testDirectory().toFile();
        String[] files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)0, (int)files.length, (String)"we should have no temp file");
        StreamCache cache = cos.newStreamCache();
        boolean b = cache instanceof InputStreamCache;
        Assertions.assertTrue((boolean)b, (String)"Should get the InputStreamCache");
        String temp = IOConverter.toString((InputStream)((InputStream)cache), null);
        Assertions.assertEquals((Object)TEST_STRING, (Object)temp, (String)"Cached a wrong file");
        IOHelper.close((Closeable)cos);
    }

    @Test
    public void testCacheStreamToMemoryAsDiskIsDisabled() throws Exception {
        this.context.getStreamCachingStrategy().setSpoolThreshold(-1L);
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes(StandardCharsets.UTF_8));
        File file = this.testDirectory().toFile();
        String[] files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)0, (int)files.length, (String)"we should have no temp file");
        StreamCache cache = cos.newStreamCache();
        boolean b = cache instanceof InputStreamCache;
        Assertions.assertTrue((boolean)b, (String)"Should get the InputStreamCache");
        String temp = IOConverter.toString((InputStream)((InputStream)cache), null);
        Assertions.assertEquals((Object)TEST_STRING, (Object)temp, (String)"Cached a wrong file");
        this.exchange.getUnitOfWork().done(this.exchange);
        IOHelper.close((Closeable)cos);
    }

    @Test
    public void testCachedOutputStreamCustomBufferSize() throws Exception {
        this.context.getStreamCachingStrategy().setBufferSize(8192);
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((int)8192, (int)cos.getStrategyBufferSize(), (String)"we should have a custom buffer size");
        File file = this.testDirectory().toFile();
        String[] files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)1, (int)files.length, (String)"we should have a temp file");
        Assertions.assertTrue((boolean)files[0].startsWith("cos"), (String)"The file name should start with cos");
        StreamCache cache = cos.newStreamCache();
        boolean b = cache instanceof FileInputStreamCache;
        Assertions.assertTrue((boolean)b, (String)"Should get the FileInputStreamCache");
        String temp = CachedOutputStreamTest.toString((InputStream)cache);
        Assertions.assertEquals((Object)TEST_STRING, (Object)temp, (String)"Cached a wrong file");
        cache.reset();
        temp = CachedOutputStreamTest.toString((InputStream)cache);
        Assertions.assertEquals((Object)TEST_STRING, (Object)temp, (String)"Cached a wrong file");
        ((InputStream)cache).close();
        files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)1, (int)files.length, (String)"we should have a temp file");
        this.exchange.getUnitOfWork().done(this.exchange);
        files = file.list();
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)0, (int)files.length, (String)"we should have no temp file");
        IOHelper.close((Closeable)cos);
    }

    @Test
    public void testCachedOutputStreamEmptyInput() throws Exception {
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange, false);
        cos.write("".getBytes(StandardCharsets.UTF_8));
        InputStream is = cos.getWrappedInputStream();
        Assertions.assertNotNull((Object)is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        IOHelper.copy((InputStream)is, (OutputStream)bos);
        Assertions.assertNotNull((Object)bos);
        byte[] data = bos.toByteArray();
        Assertions.assertEquals((int)0, (int)data.length);
        IOHelper.close((Closeable)bos);
        IOHelper.close((Closeable)cos);
    }
}

