/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.xml.BytesSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlConverterTest
extends ContextTestSupport {
    @Test
    public void testToResultNoSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        conv.toResult(null, null);
    }

    @Test
    public void testToBytesSource() {
        XmlConverter conv = new XmlConverter();
        BytesSource bs = conv.toBytesSource("<foo>bar</foo>".getBytes());
        Assertions.assertNotNull((Object)bs);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)new String(bs.getData()));
    }

    @Test
    public void testToStringFromSourceNoSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        Source source = null;
        String out = conv.toString(source, null);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void testToStringWithBytesSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        BytesSource source = conv.toBytesSource("<foo>bar</foo>".getBytes());
        String out = conv.toString((Source)source, null);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)out);
    }

    @Test
    public void testToStringWithDocument() throws Exception {
        XmlConverter conv = new XmlConverter();
        Document document = conv.createDocument();
        Element foo = document.createElement("foo");
        foo.setTextContent("bar");
        document.appendChild(foo);
        String out = conv.toStringFromDocument(document, null);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><foo>bar</foo>", (Object)out);
    }

    @Test
    public void testToStringWithDocumentSourceOutputProperties() throws Exception {
        XmlConverter conv = new XmlConverter();
        Document document = conv.createDocument();
        Element foo = document.createElement("foo");
        foo.setTextContent("bar");
        document.appendChild(foo);
        Properties properties = new Properties();
        properties.put("encoding", "ISO-8859-1");
        String out = conv.toStringFromDocument(document, properties);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?><foo>bar</foo>", (Object)out);
    }

    @Test
    public void testToSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        Source source = conv.toSource("<foo>bar</foo>");
        String out = conv.toString(source, null);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)out);
    }

    @Test
    public void testToSourceUsingTypeConverter() {
        Source source = (Source)this.context.getTypeConverter().convertTo(Source.class, (Object)"<foo>bar</foo>");
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)source);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)out);
        source = (Source)this.context.getTypeConverter().convertTo(Source.class, (Object)"<foo>baz</foo>");
        out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)source);
        Assertions.assertEquals((Object)"<foo>baz</foo>", (Object)out);
    }

    @Test
    public void testToByteArrayWithExchange() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        XmlConverter conv = new XmlConverter();
        BytesSource source = conv.toBytesSource("<foo>bar</foo>".getBytes());
        byte[] out = conv.toByteArray((Source)source, (Exchange)exchange);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)new String(out));
    }

    @Test
    public void testToByteArrayWithNoExchange() throws Exception {
        XmlConverter conv = new XmlConverter();
        BytesSource source = conv.toBytesSource("<foo>bar</foo>".getBytes());
        byte[] out = conv.toByteArray((Source)source, null);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)new String(out));
    }

    @Test
    public void testToDomSourceByDomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        DOMSource source = conv.toDOMSource("<foo>bar</foo>");
        DOMSource out = conv.toDOMSource((Source)source, null);
        Assertions.assertSame((Object)source, (Object)out);
    }

    @Test
    public void testToDomSourceByByteArray() throws Exception {
        XmlConverter conv = new XmlConverter();
        byte[] bytes = "<foo>bar</foo>".getBytes();
        DOMSource source = conv.toDOMSource(bytes);
        Assertions.assertNotNull((Object)source);
        byte[] out = conv.toByteArray((Source)source, null);
        Assertions.assertEquals((Object)new String(bytes), (Object)new String(out));
    }

    @Test
    public void testToDomSourceBySaxSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", null);
        DOMSource out = conv.toDOMSource((Source)source, null);
        Assertions.assertNotSame((Object)source, (Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToDomSourceByStAXSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        StAXSource source = conv.toStAXSource("<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>", null);
        DOMSource out = conv.toDOMSource((Source)source, null);
        Assertions.assertNotSame((Object)source, (Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToDomSourceByCustomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        Source dummy = new Source(){

            @Override
            public String getSystemId() {
                return null;
            }

            @Override
            public void setSystemId(String s) {
            }
        };
        DOMSource out = conv.toDOMSource(dummy, null);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void testToSaxSourceByInputStream() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<foo>bar</foo>");
        SAXSource out = conv.toSAXSource(is, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToStAXSourceByInputStream() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<foo>bar</foo>");
        StAXSource out = conv.toStAXSource(is, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToSaxSourceFromFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<foo>bar</foo>", "CamelFileName", (Object)"myxml.xml");
        File file = this.testFile("myxml.xml").toFile();
        SAXSource out = conv.toSAXSource(file, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)out));
    }

    @Test
    public void testToStAXSourceFromFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<foo>bar</foo>", "CamelFileName", (Object)"myxml.xml");
        File file = this.testFile("myxml.xml").toFile();
        StAXSource out = conv.toStAXSource(file, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)out));
    }

    @Test
    public void testToSaxSourceByDomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        DOMSource source = conv.toDOMSource("<foo>bar</foo>");
        SAXSource out = conv.toSAXSource((Source)source, null);
        Assertions.assertNotSame((Object)source, (Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToSaxSourceBySaxSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", null);
        SAXSource out = conv.toSAXSource((Source)source, null);
        Assertions.assertSame((Object)source, (Object)out);
    }

    @Test
    public void testToSaxSourceByCustomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        Source dummy = new Source(){

            @Override
            public String getSystemId() {
                return null;
            }

            @Override
            public void setSystemId(String s) {
            }
        };
        SAXSource out = conv.toSAXSource(dummy, null);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void testToStreamSourceByFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        File file = new File("org/apache/camel/converter/stream/test.xml");
        StreamSource source = conv.toStreamSource(file);
        StreamSource out = conv.toStreamSource((Source)source, null);
        Assertions.assertSame((Object)source, (Object)out);
    }

    @Test
    public void testToStreamSourceByStreamSource() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        XmlConverter conv = new XmlConverter();
        StreamSource source = conv.toStreamSource("<foo>bar</foo>".getBytes(), (Exchange)exchange);
        StreamSource out = conv.toStreamSource((Source)source, null);
        Assertions.assertSame((Object)source, (Object)out);
    }

    @Test
    public void testToStreamSourceByDomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        DOMSource source = conv.toDOMSource("<foo>bar</foo>");
        StreamSource out = conv.toStreamSource((Source)source, null);
        Assertions.assertNotSame((Object)source, (Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToStreamSourceBySaxSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", null);
        StreamSource out = conv.toStreamSource((Source)source, null);
        Assertions.assertNotSame((Object)source, (Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToStreamSourceByStAXSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        StAXSource source = conv.toStAXSource("<foo>bar</foo>", null);
        StreamSource out = conv.toStreamSource((Source)source, null);
        Assertions.assertNotSame((Object)source, (Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToStreamSourceByCustomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        Source dummy = new Source(){

            @Override
            public String getSystemId() {
                return null;
            }

            @Override
            public void setSystemId(String s) {
            }
        };
        StreamSource out = conv.toStreamSource(dummy, null);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void testToStreamSourceByInputStream() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<foo>bar</foo>");
        StreamSource out = conv.toStreamSource(is);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToStreamSourceByReader() throws Exception {
        XmlConverter conv = new XmlConverter();
        Reader reader = (Reader)this.context.getTypeConverter().convertTo(Reader.class, (Object)"<foo>bar</foo>");
        StreamSource out = conv.toStreamSource(reader);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToStreamSourceByByteArray() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        XmlConverter conv = new XmlConverter();
        byte[] bytes = (byte[])this.context.getTypeConverter().convertTo(byte[].class, (Object)"<foo>bar</foo>");
        StreamSource out = conv.toStreamSource(bytes, (Exchange)exchange);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToStreamSourceByByteBuffer() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        XmlConverter conv = new XmlConverter();
        ByteBuffer bytes = (ByteBuffer)this.context.getTypeConverter().convertTo(ByteBuffer.class, (Object)"<foo>bar</foo>");
        StreamSource out = conv.toStreamSource(bytes, (Exchange)exchange);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)conv.toString((Source)out, null));
    }

    @Test
    public void testToReaderFromSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", null);
        Reader out = conv.toReaderFromSource((Source)source, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)out));
    }

    @Test
    public void testToDomSourceFromInputStream() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<foo>bar</foo>");
        DOMSource out = conv.toDOMSource(is, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)out));
    }

    @Test
    public void testToDomSourceFromFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<foo>bar</foo>", "CamelFileName", (Object)"myxml.xml");
        File file = this.testFile("myxml.xml").toFile();
        DOMSource out = conv.toDOMSource(file, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)out));
    }

    @Test
    public void testToDomElement() throws Exception {
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", null);
        Element out = conv.toDOMElement((Source)source);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)out));
    }

    @Test
    public void testToDomElementFromDocumentNode() throws Exception {
        XmlConverter conv = new XmlConverter();
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        Element out = conv.toDOMElement((Node)doc);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)out));
    }

    @Test
    public void testToDomElementFromElementNode() throws Exception {
        XmlConverter conv = new XmlConverter();
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        Element out = conv.toDOMElement((Node)doc.getDocumentElement());
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)out));
    }

    @Test
    public void testToDocumentFromBytes() throws Exception {
        XmlConverter conv = new XmlConverter();
        byte[] bytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>".getBytes();
        Document out = conv.toDOMDocument(bytes, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)out));
    }

    @Test
    public void testToDocumentFromInputStream() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        Document out = conv.toDOMDocument(is, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)out));
    }

    @Test
    public void testToInputStreamFromDocument() throws Exception {
        XmlConverter conv = new XmlConverter();
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        InputStream is = conv.toInputStream(doc, null);
        Assertions.assertNotNull((Object)is);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)is));
    }

    @Test
    public void testToInputStreamNonAsciiFromDocument() throws Exception {
        XmlConverter conv = new XmlConverter();
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>\u99f1\u99ddb\u00e4r</foo>");
        InputStream is = conv.toInputStream(doc, null);
        Assertions.assertNotNull((Object)is);
        Assertions.assertEquals((Object)"<foo>\u99f1\u99ddb\u00e4r</foo>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)is));
    }

    @Test
    public void testToDocumentFromFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        File file = new File("src/test/resources/org/apache/camel/converter/stream/test.xml");
        Document out = conv.toDOMDocument(file, null);
        Assertions.assertNotNull((Object)out);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)out);
        Assertions.assertTrue((boolean)s.contains("<firstName>James</firstName>"));
    }

    @Test
    public void testToInputStreamByDomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        DOMSource source = conv.toDOMSource("<foo>bar</foo>");
        InputStream out = conv.toInputStream(source, null);
        Assertions.assertNotSame((Object)source, (Object)out);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)out);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)s);
    }

    @Test
    public void testToInputStreamNonAsciiByDomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        DOMSource source = conv.toDOMSource("<foo>\u99f1\u99ddb\u00e4r</foo>");
        InputStream out = conv.toInputStream(source, null);
        Assertions.assertNotSame((Object)source, (Object)out);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)out);
        Assertions.assertEquals((Object)"<foo>\u99f1\u99ddb\u00e4r</foo>", (Object)s);
    }

    @Test
    public void testToInputSource() {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<foo>bar</foo>");
        InputSource out = conv.toInputSource(is, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertNotNull((Object)out.getByteStream());
    }

    @Test
    public void testToInputSourceFromFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        File file = new File("src/test/resources/org/apache/camel/converter/stream/test.xml");
        InputSource out = conv.toInputSource(file, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertNotNull((Object)out.getByteStream());
    }

    @Test
    public void testOutOptionsFromCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultExchange exchange = new DefaultExchange((CamelContext)context);
        context.getGlobalOptions().put("org.apache.camel.xmlconverter.output.encoding", "UTF-8");
        context.getGlobalOptions().put("org.apache.camel.xmlconverter.output.standalone", "no");
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", (Exchange)exchange);
        DOMSource out = conv.toDOMSource((Source)source, (Exchange)exchange);
        Assertions.assertNotSame((Object)source, (Object)out);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><foo>bar</foo>", (Object)conv.toString((Source)out, (Exchange)exchange));
    }

    @Test
    public void testNodeListToNode() {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo><hello>Hello World</hello></foo>");
        NodeList nl = document.getElementsByTagName("hello");
        Assertions.assertEquals((int)1, (int)nl.getLength());
        Node node = (Node)this.context.getTypeConverter().convertTo(Node.class, (Object)nl);
        Assertions.assertNotNull((Object)node);
        document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo><hello>Hello World</hello><hello>Hello Camel</hello></foo>");
        nl = document.getElementsByTagName("hello");
        Assertions.assertEquals((int)2, (int)nl.getLength());
        node = (Node)this.context.getTypeConverter().convertTo(Node.class, (Object)nl);
        Assertions.assertNull((Object)node);
        document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo><hello>Hello World</hello></foo>");
        nl = document.getElementsByTagName("hello");
        Assertions.assertEquals((int)1, (int)nl.getLength());
        node = (Node)this.context.getTypeConverter().convertTo(Node.class, (Object)nl);
        Assertions.assertNotNull((Object)node);
    }
}

