/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StaxConverterTest
extends ContextTestSupport {
    private static final Charset ISO_8859_1 = StandardCharsets.ISO_8859_1;
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String TEST_XML = "<test>Test Message with umlaut \u00e4\u00f6\u00fc</test>";
    private static final String TEST_XML_WITH_XML_HEADER_ISO_8859_1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><test>Test Message with umlaut \u00e4\u00f6\u00fc</test>";
    private static final ByteArrayInputStream TEST_XML_WITH_XML_HEADER_ISO_8859_1_AS_BYTE_ARRAY_STREAM = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><test>Test Message with umlaut \u00e4\u00f6\u00fc</test>".getBytes(ISO_8859_1));
    private static final String TEST_XML_WITH_XML_HEADER = "<?xml version=\"1.0\"?><test>Test Message with umlaut \u00e4\u00f6\u00fc</test>";
    private static final String TEST_XML_7000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodingXmlEventReader() throws Exception {
        TEST_XML_WITH_XML_HEADER_ISO_8859_1_AS_BYTE_ARRAY_STREAM.reset();
        XMLEventReader reader = null;
        XMLEventWriter writer = null;
        ByteArrayOutputStream output = null;
        try {
            reader = (XMLEventReader)this.context.getTypeConverter().mandatoryConvertTo(XMLEventReader.class, (Object)TEST_XML_WITH_XML_HEADER_ISO_8859_1_AS_BYTE_ARRAY_STREAM);
            output = new ByteArrayOutputStream();
            DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
            exchange.setProperty("CamelCharsetName", (Object)UTF_8.toString());
            writer = (XMLEventWriter)this.context.getTypeConverter().mandatoryConvertTo(XMLEventWriter.class, (Exchange)exchange, (Object)output);
            while (reader.hasNext()) {
                writer.add(reader.nextEvent());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        Assertions.assertNotNull((Object)output);
        String result = output.toString(UTF_8);
        if (result.indexOf(39) > 0) {
            result = result.replace('\'', '\"');
        }
        boolean equals = TEST_XML_WITH_XML_HEADER.equals(result) || TEST_XML_WITH_XML_HEADER_ISO_8859_1.equals(result);
        Assertions.assertTrue((boolean)equals, (String)"Should match header");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodingXmlStreamReader() throws Exception {
        TEST_XML_WITH_XML_HEADER_ISO_8859_1_AS_BYTE_ARRAY_STREAM.reset();
        XMLStreamReader reader = null;
        XMLStreamWriter writer = null;
        ByteArrayOutputStream output = null;
        try {
            reader = (XMLStreamReader)this.context.getTypeConverter().mandatoryConvertTo(XMLStreamReader.class, (Object)TEST_XML_WITH_XML_HEADER_ISO_8859_1_AS_BYTE_ARRAY_STREAM);
            output = new ByteArrayOutputStream();
            DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
            exchange.setProperty("CamelCharsetName", (Object)UTF_8.name());
            writer = (XMLStreamWriter)this.context.getTypeConverter().mandatoryConvertTo(XMLStreamWriter.class, (Exchange)exchange, (Object)output);
            block10: while (reader.hasNext()) {
                reader.next();
                switch (reader.getEventType()) {
                    case 7: {
                        writer.writeStartDocument();
                        continue block10;
                    }
                    case 8: {
                        writer.writeEndDocument();
                        continue block10;
                    }
                    case 1: {
                        writer.writeStartElement(reader.getName().getLocalPart());
                        continue block10;
                    }
                    case 4: {
                        writer.writeCharacters(reader.getText());
                        continue block10;
                    }
                    case 2: {
                        writer.writeEndElement();
                        continue block10;
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        Assertions.assertNotNull((Object)output);
        String result = output.toString(UTF_8);
        Assertions.assertEquals((Object)TEST_XML, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToReaderByXmlStreamReader() throws Exception {
        StringReader src = new StringReader(TEST_XML_7000);
        XMLStreamReader xreader = null;
        Reader reader = null;
        try {
            xreader = (XMLStreamReader)this.context.getTypeConverter().mandatoryConvertTo(XMLStreamReader.class, (Object)src);
            reader = (Reader)this.context.getTypeConverter().mandatoryConvertTo(Reader.class, (Object)xreader);
            StringReader expected = new StringReader(TEST_XML_7000);
            char[] tmp1 = new char[512];
            char[] tmp2 = new char[512];
            while (true) {
                int n1 = 0;
                int n2 = 0;
                try {
                    n1 = expected.read(tmp1, 0, tmp1.length);
                    n2 = reader.read(tmp2, 0, tmp2.length);
                }
                catch (IOException e) {
                    Assertions.fail((String)"unable to read data");
                }
                Assertions.assertEquals((int)n1, (int)n2);
                if (n2 < 0) {
                    break;
                }
                Assertions.assertArrayEquals((char[])tmp1, (char[])tmp2);
            }
        }
        finally {
            if (xreader != null) {
                xreader.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToInputSreamByXmlStreamReader() throws Exception {
        StringReader src = new StringReader(TEST_XML_7000);
        XMLStreamReader xreader = null;
        InputStream in = null;
        try {
            xreader = (XMLStreamReader)this.context.getTypeConverter().mandatoryConvertTo(XMLStreamReader.class, (Object)src);
            in = (InputStream)this.context.getTypeConverter().mandatoryConvertTo(InputStream.class, (Object)xreader);
            ByteArrayInputStream expected = new ByteArrayInputStream(TEST_XML_7000.getBytes(StandardCharsets.UTF_8));
            byte[] tmp1 = new byte[512];
            byte[] tmp2 = new byte[512];
            while (true) {
                int n1 = 0;
                int n2 = 0;
                try {
                    n1 = ((InputStream)expected).read(tmp1, 0, tmp1.length);
                    n2 = in.read(tmp2, 0, tmp2.length);
                }
                catch (IOException e) {
                    Assertions.fail((String)"unable to read data");
                }
                Assertions.assertEquals((int)n1, (int)n2);
                if (n2 < 0) {
                    break;
                }
                Assertions.assertArrayEquals((byte[])tmp1, (byte[])tmp2);
            }
        }
        finally {
            if (xreader != null) {
                xreader.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    static {
        StringBuilder sb = new StringBuilder(7000);
        sb.append("<?xml version='1.0' encoding='utf-8'?>").append("<list>");
        for (int n = 6963 - TEST_XML.length(); n > 0; n -= TEST_XML.length()) {
            sb.append(TEST_XML);
        }
        sb.append("</list>");
        TEST_XML_7000 = sb.toString();
    }
}

