/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.builder.xml.StAX2SAXSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Test;

public class StAX2SAXSourceTest
extends ContextTestSupport {
    private static final String TEST_XML = "<root xmlns=\"urn:org.apache.camel:test\">Text</root>";
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    @Test
    public void testDefaultPrefixInRootElementWithCopyTransformer() throws Exception {
        TransformerFactory trf = TransformerFactory.newInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamReader reader = (XMLStreamReader)this.context.getTypeConverter().mandatoryConvertTo(XMLStreamReader.class, (Object)new StringReader(TEST_XML));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setProperty("CamelCharsetName", (Object)UTF_8.toString());
        XMLStreamWriter writer = (XMLStreamWriter)this.context.getTypeConverter().mandatoryConvertTo(XMLStreamWriter.class, (Exchange)exchange, (Object)baos);
        StAX2SAXSource staxSource = new StAX2SAXSource(reader);
        StreamSource templateSource = new StreamSource(this.getClass().getResourceAsStream("/xslt/common/copy.xsl"));
        Transformer transformer = trf.newTransformer(templateSource);
        this.log.info("Used transformer: {}", (Object)transformer.getClass().getName());
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform((Source)staxSource, new StreamResult(baos));
        writer.flush();
        baos.flush();
        MatcherAssert.assertThat((Object)baos.toString(), (Matcher)IsEqual.equalTo((Object)TEST_XML));
    }
}

