/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.converter.jaxp.DomConverter;
import org.apache.camel.util.ObjectHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DomConverterTest
extends ContextTestSupport {
    @Test
    public void testDomConverterToString() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>world!</hello>");
        String s = new DomConverter().toString(document.getChildNodes(), null);
        Assertions.assertEquals((Object)"<hello>world!</hello>", (Object)s);
    }

    @Test
    public void testDomConverterToBytes() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>world!</hello>");
        byte[] bytes = new DomConverter().toByteArray(document.getChildNodes(), null);
        Assertions.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])"<hello>world!</hello>".getBytes(StandardCharsets.UTF_8), (byte[])bytes), (String)"Should be equal");
    }

    @Test
    public void testDomConverterToNoAssicBytes() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>\u99f1\u99ddb\u00e4r</foo>");
        byte[] bytes = new DomConverter().toByteArray(document.getChildNodes(), null);
        Assertions.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])"<foo>\u99f1\u99ddb\u00e4r</foo>".getBytes(StandardCharsets.UTF_8), (byte[])bytes), (String)"Should be equal");
    }

    @Test
    public void testDomConverterToInteger() {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>47</hello>");
        Integer number = DomConverter.toInteger((NodeList)document.getChildNodes());
        Assertions.assertEquals((int)47, (int)number);
    }

    @Test
    public void testDomConverterToLong() {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>47</hello>");
        Long number = DomConverter.toLong((NodeList)document.getChildNodes());
        Assertions.assertEquals((long)47L, (long)number);
    }

    @Test
    public void testDomConverterToList() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo><hello>Hello World</hello><bye>Bye Camel</bye></foo>");
        List list = DomConverter.toList((NodeList)document.getElementsByTagName("foo"));
        Assertions.assertEquals((int)1, (int)list.size());
        NodeList nl = DomConverterTest.assertIsInstanceOf(NodeList.class, list.get(0));
        List sub = DomConverter.toList((NodeList)nl);
        Assertions.assertEquals((int)2, (int)sub.size());
        Assertions.assertEquals((Object)"<hello>Hello World</hello>", (Object)new DomConverter().toString((NodeList)sub.get(0), null));
        Assertions.assertEquals((Object)"<bye>Bye Camel</bye>", (Object)new DomConverter().toString((NodeList)sub.get(1), null));
    }

    @Test
    public void testDomConverterToInputStream() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>world!</hello>");
        InputStream is = new DomConverter().toInputStream(document.getChildNodes(), null);
        Assertions.assertEquals((Object)"<hello>world!</hello>", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)is));
    }
}

