/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.ObjectHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeCoerceCompareTest
extends ContextTestSupport {
    @Test
    public void testCompareStringString() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)"7") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)"7.5") > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)"40"));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7", (Object)"40") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)"40") < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)"7.5"));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)"7.5"));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.0", (Object)"7"));
    }

    @Test
    public void testCompareStringInteger() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)7) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)40));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7", (Object)40) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)40) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.0", (Object)7));
    }

    @Test
    public void testCompareStringLong() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)7L) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)40L));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7", (Object)40L) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)40L) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.0", (Object)7L));
    }

    @Test
    public void testCompareStringDouble() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)7.0) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)7.5) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)40.0));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7", (Object)40.0) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)40.0) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)7.5));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)7.5));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.0", (Object)7.0));
    }

    @Test
    public void testCompareStringFloat() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)Float.valueOf(7.0f)) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)Float.valueOf(7.5f)) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"40", (Object)Float.valueOf(40.0f)));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7", (Object)Float.valueOf(40.0f)) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)Float.valueOf(40.0f)) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)Float.valueOf(7.5f)));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.5", (Object)Float.valueOf(7.5f)));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)"7.0", (Object)Float.valueOf(7.0f)));
    }

    @Test
    public void testCompareIntegerString() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)"7") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)"7.5") > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)"40"));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)"40") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)"7.5") < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)"7"));
    }

    @Test
    public void testCompareLongString() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)"7") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)"7.5") > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)"40"));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)"40") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)"7.5") < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)"7"));
    }

    @Test
    public void testCompareDoubleString() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40.0, (Object)"7") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40.5, (Object)"7.5") > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40.0, (Object)"40"));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7.0, (Object)"40.5") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7.5, (Object)"40") < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7.5, (Object)"7.5"));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7.5, (Object)"7.5"));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7.0, (Object)"7"));
    }

    @Test
    public void testCompareFloatString() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(40.0f), (Object)"7") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(40.5f), (Object)"7.5") > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(40.0f), (Object)"40"));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(7.0f), (Object)"40.5") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(7.5f), (Object)"40") < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(7.5f), (Object)"7.5"));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(7.5f), (Object)"7.5"));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(7.0f), (Object)"7"));
    }

    @Test
    public void testCompareIntegerInteger() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)7) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)40));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)40) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)8, (Object)40) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)7));
    }

    @Test
    public void testCompareLongLong() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)7L) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)40L));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)40L) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)8L, (Object)40L) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)7L));
    }

    @Test
    public void testCompareIntegerLong() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)7L) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)40L));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)40L) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)8, (Object)40L) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)7L));
    }

    @Test
    public void testCompareLongInteger() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)7) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)40));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)40) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)8L, (Object)40) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)7));
    }

    @Test
    public void testCompareDoubleInteger() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40.5, (Object)7) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40.0, (Object)40));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7.5, (Object)40) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)8.0, (Object)40) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7.0, (Object)7));
    }

    @Test
    public void testCompareIntegerDouble() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)7.5) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)40.0));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)40.0) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)8, (Object)40.0) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)7.0));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)7.0));
    }

    @Test
    public void testCompareDoubleLong() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40.5, (Object)7L) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40.0, (Object)40L));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7.5, (Object)40L) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)8.0, (Object)40L) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7.0, (Object)7L));
    }

    @Test
    public void testCompareLongDouble() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)7.5) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)40.0));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)40.5) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)8L, (Object)40.0) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)7.0));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)7.0));
    }

    @Test
    public void testCompareFloatInteger() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(40.5f), (Object)7) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(40.0f), (Object)40));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(7.5f), (Object)40) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(8.0f), (Object)40) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(7.0f), (Object)7));
    }

    @Test
    public void testCompareIntegerFloat() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)Float.valueOf(7.5f)) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40, (Object)Float.valueOf(40.0f)));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)Float.valueOf(40.0f)) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)8, (Object)Float.valueOf(40.0f)) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7, (Object)Float.valueOf(7.0f)));
    }

    @Test
    public void testCompareFloatLong() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(40.5f), (Object)7L) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(40.0f), (Object)40L));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(7.5f), (Object)40L) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(8.0f), (Object)40L) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)Float.valueOf(7.0f), (Object)7L));
    }

    @Test
    public void testCompareLongFloat() {
        TypeConverter tc = this.context.getTypeConverter();
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)Float.valueOf(7.5f)) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)40L, (Object)Float.valueOf(40.0f)));
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)Float.valueOf(40.0f)) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)8L, (Object)Float.valueOf(40.0f)) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)Float.valueOf(7.0f)));
        Assertions.assertEquals((int)0, (int)ObjectHelper.typeCoerceCompare((TypeConverter)tc, (Object)7L, (Object)Float.valueOf(7.0f)));
    }

    @Test
    public void testPredicate() throws Exception {
        this.getMockEndpoint("mock:match").expectedBodiesReceived(new Object[]{"40", "8", "7.5", Float.valueOf(41.0f), Float.valueOf(8.0f), Float.valueOf(7.5f)});
        this.getMockEndpoint("mock:other").expectedBodiesReceived(new Object[]{"6", "1", Float.valueOf(5.0f), Float.valueOf(2.0f)});
        this.template.sendBody("direct:start", (Object)"40");
        this.template.sendBody("direct:start", (Object)"8");
        this.template.sendBody("direct:start", (Object)"7.5");
        this.template.sendBody("direct:start", (Object)"6");
        this.template.sendBody("direct:start", (Object)"1");
        this.template.sendBody("direct:start", (Object)Float.valueOf(41.0f));
        this.template.sendBody("direct:start", (Object)Float.valueOf(8.0f));
        this.template.sendBody("direct:start", (Object)Float.valueOf(7.5f));
        this.template.sendBody("direct:start", (Object)Float.valueOf(5.0f));
        this.template.sendBody("direct:start", (Object)Float.valueOf(2.0f));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPredicate2() throws Exception {
        this.getMockEndpoint("mock:match2").expectedBodiesReceived(new Object[]{"40", "8", "7.0", Float.valueOf(41.0f), Float.valueOf(8.0f), Float.valueOf(7.0f)});
        this.getMockEndpoint("mock:other2").expectedBodiesReceived(new Object[]{"6", "1", Float.valueOf(5.0f), Float.valueOf(2.0f)});
        this.template.sendBody("direct:start2", (Object)"40");
        this.template.sendBody("direct:start2", (Object)"8");
        this.template.sendBody("direct:start2", (Object)"7.0");
        this.template.sendBody("direct:start2", (Object)"6");
        this.template.sendBody("direct:start2", (Object)"1");
        this.template.sendBody("direct:start2", (Object)Float.valueOf(41.0f));
        this.template.sendBody("direct:start2", (Object)Float.valueOf(8.0f));
        this.template.sendBody("direct:start2", (Object)Float.valueOf(7.0f));
        this.template.sendBody("direct:start2", (Object)Float.valueOf(5.0f));
        this.template.sendBody("direct:start2", (Object)Float.valueOf(2.0f));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").setProperty("left", (Expression)this.simple("${body}"))).setProperty("right", (Expression)this.simple("7.5"))).choice().when((Predicate)this.simple("${exchangeProperty.left} >= ${exchangeProperty.right}")).to("mock:match")).otherwise().to("mock:other")).end();
                ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start2").setProperty("left", (Expression)this.simple("${body}"))).setProperty("right", (Expression)this.simple("7"))).choice().when((Predicate)this.simple("${exchangeProperty.left} >= ${exchangeProperty.right}")).to("mock:match2")).otherwise().to("mock:other2")).end();
            }
        };
    }
}

