/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Isolated
public class TimerDrivenTimePatternConverterTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TimerDrivenTimePatternConverterTest.class);

    @Test
    public void testTimerInvocation() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTimerUsingStopWatch() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(2);
        StopWatch watch = new StopWatch();
        this.assertMockEndpointsSatisfied();
        long interval = watch.taken();
        LOG.trace("Should take approx 50 milliseconds, was: {}", (Object)interval);
        Assertions.assertTrue((interval >= 40L ? 1 : 0) != 0, (String)("Should take approx 50 milliseconds, was: " + interval));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("timer://foo?fixedRate=true&delay=0&period=50").to("mock:result");
            }
        };
    }
}

