/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.util.TimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimePatternTypeConversionTest
extends ContextTestSupport {
    @Test
    public void testForNoSideEffects() {
        long milliseconds = TimeUtils.toMilliSeconds((String)"444");
        Assertions.assertEquals((long)Long.valueOf("444"), (long)milliseconds);
    }

    @Test
    public void testForNoSideEffects2() {
        long milliseconds = TimeUtils.toMilliSeconds((String)"-72");
        Assertions.assertEquals((long)Long.valueOf("-72"), (long)milliseconds);
    }

    @Test
    public void testHMSTimePattern() {
        long milliseconds = TimeUtils.toMilliSeconds((String)"1h30m1s");
        Assertions.assertEquals((long)5401000L, (long)milliseconds);
    }

    @Test
    public void testMTimePattern() {
        long milliseconds = TimeUtils.toMilliSeconds((String)"5m");
        Assertions.assertEquals((long)300000L, (long)milliseconds);
    }

    @Test
    public void testMandSTimePattern() {
        long milliseconds = TimeUtils.toMilliSeconds((String)"30m55s");
        Assertions.assertEquals((long)1855000L, (long)milliseconds);
    }

    @Test
    public void testSecondsPattern() {
        long milliseconds = TimeUtils.toMilliSeconds((String)"300s");
        Assertions.assertEquals((long)300000L, (long)milliseconds);
    }

    @Test
    public void testMillisPattern() {
        long milliseconds = TimeUtils.toMilliSeconds((String)"300ms");
        Assertions.assertEquals((long)300L, (long)milliseconds);
    }
}

