/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.engine.DefaultPackageScanClassResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ReflectionInjector;
import org.apache.camel.util.xml.StringSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StringSourceTest {
    protected TypeConverter converter = new DefaultTypeConverter((PackageScanClassResolver)new DefaultPackageScanClassResolver(), (Injector)new ReflectionInjector(), false, false);
    protected String expectedBody = "<hello>world!</hello>";

    @BeforeEach
    public void setUp() {
        ServiceHelper.startService((Object)this.converter);
    }

    @Test
    public void testSerialization() throws Exception {
        StringSource expected = new StringSource(this.expectedBody, "mySystemID", "utf-8");
        expected.setPublicId("myPublicId");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream output = new ObjectOutputStream(buffer);
        output.writeObject(expected);
        output.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        Object object = in.readObject();
        boolean b = object instanceof StringSource;
        Assertions.assertTrue((boolean)b, (String)"is a StringSource");
        StringSource actual = (StringSource)object;
        Assertions.assertEquals((Object)expected.getPublicId(), (Object)actual.getPublicId(), (String)"source.text");
        Assertions.assertEquals((Object)expected.getSystemId(), (Object)actual.getSystemId(), (String)"source.text");
        Assertions.assertEquals((Object)expected.getEncoding(), (Object)actual.getEncoding(), (String)"source.text");
        Assertions.assertEquals((Object)expected.getText(), (Object)actual.getText(), (String)"source.text");
        String value = (String)this.converter.convertTo(String.class, (Object)actual);
        Assertions.assertEquals((Object)this.expectedBody, (Object)value, (String)"text value of StringSource");
    }
}

