/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StaticFallbackConverterTest
extends ContextTestSupport {
    @Test
    public void testStaticFallbackConverter() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        TimeZone tz = TimeZone.getDefault();
        String money = (String)this.context.getTypeConverter().convertTo(String.class, (Exchange)exchange, (Object)tz);
        Assertions.assertEquals((Object)"Time talks", (Object)money);
    }

    @Test
    public void testStaticFallbackMandatoryConverter() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        TimeZone tz = TimeZone.getDefault();
        String money = (String)this.context.getTypeConverter().mandatoryConvertTo(String.class, (Exchange)exchange, (Object)tz);
        Assertions.assertEquals((Object)"Time talks", (Object)money);
    }

    @Test
    public void testStaticFallbackMandatoryFailed() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Assertions.assertThrows(NoTypeConversionAvailableException.class, () -> this.lambda$testStaticFallbackMandatoryFailed$0((Exchange)exchange), (String)"Should have thrown an exception");
    }

    @Test
    public void testStaticFallbackFailed() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Date out = (Date)this.context.getTypeConverter().convertTo(Date.class, (Exchange)exchange, (Object)new Timestamp(0L));
        Assertions.assertNull((Object)out);
    }

    private /* synthetic */ void lambda$testStaticFallbackMandatoryFailed$0(Exchange exchange) throws Throwable {
        this.context.getTypeConverter().mandatoryConvertTo(Date.class, exchange, (Object)new Timestamp(0L));
    }
}

