/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourceConverterTest
extends ContextTestSupport {
    @Test
    public void testMem() {
        Resource res = (Resource)this.context.getTypeConverter().convertTo(Resource.class, (Object)"mem:foo");
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)res);
        Assertions.assertEquals((Object)"foo", (Object)out);
    }

    @Test
    public void testBase64() {
        String b64 = Base64.getEncoder().encodeToString("Hello Camel".getBytes(StandardCharsets.UTF_8));
        Resource res = (Resource)this.context.getTypeConverter().convertTo(Resource.class, (Object)("base64:" + b64));
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)res);
        Assertions.assertEquals((Object)"Hello Camel", (Object)out);
    }

    @Test
    public void testClasspath() {
        Resource res = (Resource)this.context.getTypeConverter().convertTo(Resource.class, (Object)"classpath:myxpath.txt");
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)res);
        Assertions.assertEquals((Object)"/person/name/text()", (Object)out);
    }

    @Test
    public void testFile() {
        Resource res = (Resource)this.context.getTypeConverter().convertTo(Resource.class, (Object)"file:src/test/resources/mysimple.txt");
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)res);
        Assertions.assertEquals((Object)"The name is ${body}", (Object)out);
    }

    @Test
    public void testRef() {
        this.context.getRegistry().bind("foo", (Object)"Hello Foo");
        Resource res = (Resource)this.context.getTypeConverter().convertTo(Resource.class, (Object)"ref:foo");
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)res);
        Assertions.assertEquals((Object)"Hello Foo", (Object)out);
    }
}

