/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.camel.converter.ObjectConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectConverterTest {
    @Test
    public void testIterator() {
        Iterator it = ObjectConverter.iterator((Object)"Claus,Jonathan");
        Assertions.assertEquals((Object)"Claus", it.next());
        Assertions.assertEquals((Object)"Jonathan", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testStreamIterator() {
        Iterator it = ObjectConverter.iterator(Stream.of("Claus", "Jonathan", "Andrea"));
        Assertions.assertEquals((Object)"Claus", it.next());
        Assertions.assertEquals((Object)"Jonathan", it.next());
        Assertions.assertEquals((Object)"Andrea", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIterable() {
        Iterator iterator = ObjectConverter.iterable((Object)"Claus,Jonathan").iterator();
        block7: while (iterator.hasNext()) {
            String name;
            switch (name = (String)iterator.next()) {
                case "Claus": 
                case "Jonathan": {
                    continue block7;
                }
            }
            Assertions.fail();
        }
    }

    @Test
    public void testToByte() {
        Assertions.assertEquals((Byte)Byte.valueOf("4"), (Byte)ObjectConverter.toByte((Number)Byte.valueOf("4")));
        Assertions.assertEquals((Byte)Byte.valueOf("4"), (Byte)ObjectConverter.toByte((Number)Integer.valueOf("4")));
        Assertions.assertEquals((Byte)Byte.valueOf("4"), (Byte)ObjectConverter.toByte((String)"4"));
        Assertions.assertEquals((Byte)Byte.valueOf("4"), (Byte)ObjectConverter.toByte((byte[])"4".getBytes(StandardCharsets.UTF_8), null));
    }

    @Test
    public void testToClass() {
        Assertions.assertEquals(String.class, (Object)ObjectConverter.toClass((String)"java.lang.String", null));
        Assertions.assertNull((Object)ObjectConverter.toClass((String)"foo.Bar", null));
    }

    @Test
    public void testToShort() {
        Assertions.assertEquals((Short)Short.valueOf("4"), (Short)ObjectConverter.toShort((Number)Short.valueOf("4")));
        Assertions.assertEquals((Short)Short.valueOf("4"), (Short)ObjectConverter.toShort((Number)Integer.valueOf("4")));
        Assertions.assertEquals((Short)Short.valueOf("4"), (Short)ObjectConverter.toShort((String)"4"));
        Assertions.assertEquals((Short)Short.valueOf("4"), (Short)ObjectConverter.toShort((byte[])"4".getBytes(StandardCharsets.UTF_8), null));
        Assertions.assertNull((Object)ObjectConverter.toShort((Number)Double.NaN));
        Assertions.assertNull((Object)ObjectConverter.toShort((Number)Float.valueOf(Float.NaN)));
        Assertions.assertEquals((Short)Short.valueOf("4"), (Short)ObjectConverter.toShort((Number)Short.valueOf("4")));
    }

    @Test
    public void testToInteger() {
        Assertions.assertEquals((Integer)Integer.valueOf("4"), (Integer)ObjectConverter.toInteger((Number)Integer.valueOf("4")));
        Assertions.assertEquals((Integer)Integer.valueOf("4"), (Integer)ObjectConverter.toInteger((Number)Long.valueOf("4")));
        Assertions.assertEquals((Integer)Integer.valueOf("4"), (Integer)ObjectConverter.toInteger((String)"4"));
        Assertions.assertEquals((Integer)Integer.valueOf("4"), (Integer)ObjectConverter.toInteger((byte[])"4".getBytes(StandardCharsets.UTF_8), null));
        Assertions.assertNull((Object)ObjectConverter.toInteger((Number)Double.NaN));
        Assertions.assertNull((Object)ObjectConverter.toInteger((Number)Float.valueOf(Float.NaN)));
        Assertions.assertEquals((Integer)Integer.valueOf("4"), (Integer)ObjectConverter.toInteger((Number)Integer.valueOf("4")));
        Assertions.assertEquals((Integer)Integer.valueOf("1234"), (Integer)ObjectConverter.toInteger((byte[])new byte[]{49, 50, 51, 52}, null));
    }

    @Test
    public void testToLong() {
        Assertions.assertEquals((Long)Long.valueOf("4"), (Long)ObjectConverter.toLong((Number)Long.valueOf("4")));
        Assertions.assertEquals((Long)Long.valueOf("4"), (Long)ObjectConverter.toLong((Number)Integer.valueOf("4")));
        Assertions.assertEquals((Long)Long.valueOf("4"), (Long)ObjectConverter.toLong((String)"4"));
        Assertions.assertEquals((Long)Long.valueOf("4"), (Long)ObjectConverter.toLong((byte[])"4".getBytes(StandardCharsets.UTF_8), null));
        Assertions.assertNull((Object)ObjectConverter.toLong((Number)Double.NaN));
        Assertions.assertNull((Object)ObjectConverter.toLong((Number)Float.valueOf(Float.NaN)));
        Assertions.assertEquals((Long)Long.valueOf("4"), (Long)ObjectConverter.toLong((Number)Long.valueOf("4")));
        Assertions.assertEquals((Long)Long.valueOf("1234"), (Long)ObjectConverter.toLong((byte[])new byte[]{49, 50, 51, 52}, null));
    }

    @Test
    public void testToFloat() {
        Assertions.assertEquals((Float)Float.valueOf("4"), (Float)ObjectConverter.toFloat((Number)Float.valueOf("4")));
        Assertions.assertEquals((Float)Float.valueOf("4"), (Float)ObjectConverter.toFloat((Number)Integer.valueOf("4")));
        Assertions.assertEquals((Float)Float.valueOf("4"), (Float)ObjectConverter.toFloat((String)"4"));
        Assertions.assertEquals((Float)Float.valueOf("4"), (Float)ObjectConverter.toFloat((byte[])"4".getBytes(StandardCharsets.UTF_8), null));
        Assertions.assertEquals((Float)Float.valueOf(Float.NaN), (Float)ObjectConverter.toFloat((Number)Double.NaN));
        Assertions.assertEquals((Float)Float.valueOf(Float.NaN), (Float)ObjectConverter.toFloat((Number)Float.valueOf(Float.NaN)));
        Assertions.assertEquals((Float)Float.valueOf("4"), (Float)ObjectConverter.toFloat((Number)Float.valueOf("4")));
    }

    @Test
    public void testToDouble() {
        Assertions.assertEquals((Double)Double.valueOf("4"), (Double)ObjectConverter.toDouble((Number)Double.valueOf("4")));
        Assertions.assertEquals((Double)Double.valueOf("4"), (Double)ObjectConverter.toDouble((Number)Integer.valueOf("4")));
        Assertions.assertEquals((Double)Double.valueOf("4"), (Double)ObjectConverter.toDouble((String)"4"));
        Assertions.assertEquals((Double)Double.valueOf("4"), (Double)ObjectConverter.toDouble((byte[])"4".getBytes(StandardCharsets.UTF_8), null));
        Assertions.assertEquals((Double)Double.NaN, (Double)ObjectConverter.toDouble((Number)Double.NaN));
        Assertions.assertEquals((Double)Double.NaN, (Double)ObjectConverter.toDouble((Number)Float.valueOf(Float.NaN)));
        Assertions.assertEquals((Double)Double.valueOf("4"), (Double)ObjectConverter.toDouble((Number)Double.valueOf("4")));
    }

    @Test
    public void testToBigInteger() {
        Assertions.assertEquals((Object)BigInteger.valueOf(4L), (Object)ObjectConverter.toBigInteger((Object)Long.valueOf("4")));
        Assertions.assertEquals((Object)BigInteger.valueOf(4L), (Object)ObjectConverter.toBigInteger((Object)Integer.valueOf("4")));
        Assertions.assertEquals((Object)BigInteger.valueOf(4L), (Object)ObjectConverter.toBigInteger((Object)"4"));
        Assertions.assertEquals((Object)BigInteger.valueOf(123456789L), (Object)ObjectConverter.toBigInteger((Object)"123456789"));
        Assertions.assertNull((Object)ObjectConverter.toBigInteger((Object)new Date()));
        Assertions.assertNull((Object)ObjectConverter.toBigInteger((Object)Double.NaN));
        Assertions.assertNull((Object)ObjectConverter.toBigInteger((Object)Float.valueOf(Float.NaN)));
        Assertions.assertEquals((Object)BigInteger.valueOf(4L), (Object)ObjectConverter.toBigInteger((Object)Long.valueOf("4")));
        Assertions.assertEquals((Object)new BigInteger("14350442579497085228"), (Object)ObjectConverter.toBigInteger((Object)"14350442579497085228"));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"ABC", (Object)ObjectConverter.toString((StringBuffer)new StringBuffer("ABC")));
        Assertions.assertEquals((Object)"ABC", (Object)ObjectConverter.toString((StringBuilder)new StringBuilder("ABC")));
        Assertions.assertEquals((Object)"", (Object)ObjectConverter.toString((StringBuffer)new StringBuffer()));
        Assertions.assertEquals((Object)"", (Object)ObjectConverter.toString((StringBuilder)new StringBuilder()));
    }

    @Test
    public void testToChar() {
        Assertions.assertEquals((char)'A', (char)ObjectConverter.toChar((String)"A"));
        Assertions.assertEquals((char)'A', (char)ObjectConverter.toChar((byte[])"A".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((Character)Character.valueOf('A'), (Character)ObjectConverter.toCharacter((String)"A"));
        Assertions.assertEquals((Character)Character.valueOf('A'), (Character)ObjectConverter.toCharacter((byte[])"A".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testNaN() {
        Assertions.assertEquals((Double)Double.NaN, (Double)ObjectConverter.toDouble((Number)Double.NaN));
        Assertions.assertEquals((Double)Double.NaN, (Double)ObjectConverter.toDouble((Number)Float.valueOf(Float.NaN)));
        Assertions.assertEquals((Float)Float.valueOf(Float.NaN), (Float)ObjectConverter.toFloat((Number)Double.NaN));
        Assertions.assertEquals((Float)Float.valueOf(Float.NaN), (Float)ObjectConverter.toFloat((Number)Float.valueOf(Float.NaN)));
    }

    @Test
    public void testToBoolean() {
        Assertions.assertTrue((boolean)ObjectConverter.toBoolean((String)"true"));
        Assertions.assertTrue((boolean)ObjectConverter.toBoolean((Object)"true".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertTrue((boolean)ObjectConverter.toBoolean((String)"TRUE"));
        Assertions.assertFalse((boolean)ObjectConverter.toBoolean((String)"false"));
        Assertions.assertFalse((boolean)ObjectConverter.toBoolean((String)"FALSE"));
        Assertions.assertNull((Object)ObjectConverter.toBoolean((String)"1"));
        Assertions.assertNull((Object)ObjectConverter.toBoolean((String)""));
        Assertions.assertNull((Object)ObjectConverter.toBoolean((String)"yes"));
        Assertions.assertTrue((boolean)ObjectConverter.toBool((Object)"true"));
        Assertions.assertTrue((boolean)ObjectConverter.toBool((Object)"true".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertTrue((boolean)ObjectConverter.toBool((Object)"TRUE"));
        Assertions.assertFalse((boolean)ObjectConverter.toBool((Object)"false"));
        Assertions.assertFalse((boolean)ObjectConverter.toBool((Object)"FALSE"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectConverter.toBool((Object)"1"), (String)"Should throw exception");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectConverter.toBool((Object)""), (String)"Should throw exception");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectConverter.toBool((Object)"yes"), (String)"Should throw exception");
    }
}

