/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.NIOConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NIOConverterTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testToByteArray() {
        ByteBuffer bb = ByteBuffer.wrap("Hello".getBytes());
        byte[] out = NIOConverter.toByteArray((ByteBuffer)bb);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)5, (int)out.length);
    }

    @Test
    public void testToByteArrayBigBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(100);
        bb.put("Hello".getBytes());
        bb.flip();
        byte[] out = NIOConverter.toByteArray((ByteBuffer)bb);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)5, (int)out.length);
    }

    @Test
    public void testToString() throws Exception {
        ByteBuffer bb = ByteBuffer.wrap("Hello".getBytes());
        String out = NIOConverter.toString((ByteBuffer)bb, null);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"Hello", (Object)out);
    }

    @Test
    public void testByteBufferToStringConversion() throws Exception {
        String str = "123456789";
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.put(str.getBytes());
        buffer.flip();
        String out = NIOConverter.toString((ByteBuffer)buffer, null);
        Assertions.assertEquals((Object)str, (Object)out);
    }

    @Test
    public void testToByteBuffer() {
        ByteBuffer bb = NIOConverter.toByteBuffer((byte[])"Hello".getBytes());
        Assertions.assertNotNull((Object)bb);
    }

    @Test
    public void testToByteBufferByteArrayOutputStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(72);
        Assertions.assertEquals((int)72, (int)NIOConverter.toByteBuffer((ByteArrayOutputStream)baos).get());
    }

    @Test
    public void testToByteBufferString() {
        ByteBuffer bb = NIOConverter.toByteBuffer((String)"Hello", null);
        Assertions.assertNotNull((Object)bb);
    }

    @Test
    public void testToByteBufferFile() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        ByteBuffer bb = NIOConverter.toByteBuffer((File)this.testFile(TEST_FILE_NAME).toFile());
        Assertions.assertNotNull((Object)bb);
        Assertions.assertEquals((Object)"Hello World", (Object)NIOConverter.toString((ByteBuffer)bb, null));
    }

    @Test
    public void testToByteBufferShort() {
        ByteBuffer bb = NIOConverter.toByteBuffer((Short)Short.valueOf("2"));
        Assertions.assertNotNull((Object)bb);
        Assertions.assertEquals((int)2, (int)bb.getShort());
    }

    @Test
    public void testToByteBufferInteger() {
        ByteBuffer bb = NIOConverter.toByteBuffer((Integer)Integer.valueOf("2"));
        Assertions.assertNotNull((Object)bb);
        Assertions.assertEquals((int)2, (int)bb.getInt());
    }

    @Test
    public void testToByteBufferLong() {
        ByteBuffer bb = NIOConverter.toByteBuffer((Long)Long.valueOf("2"));
        Assertions.assertNotNull((Object)bb);
        Assertions.assertEquals((long)2L, (long)bb.getLong());
    }

    @Test
    public void testToByteBufferDouble() {
        ByteBuffer bb = NIOConverter.toByteBuffer((Double)Double.valueOf("2"));
        Assertions.assertNotNull((Object)bb);
        Assertions.assertEquals((double)2.0, (double)bb.getDouble(), (double)1.0E-5);
    }

    @Test
    public void testToByteBufferFloat() {
        ByteBuffer bb = NIOConverter.toByteBuffer((Float)Float.valueOf("2"));
        Assertions.assertNotNull((Object)bb);
        Assertions.assertEquals((double)2.0, (double)bb.getFloat(), (double)1.0E-5f);
    }

    @Test
    public void testToInputStream() throws Exception {
        ByteBuffer bb = ByteBuffer.wrap("Hello".getBytes());
        InputStream is = NIOConverter.toInputStream((ByteBuffer)bb);
        Assertions.assertNotNull((Object)is);
        Assertions.assertEquals((Object)"Hello", (Object)IOConverter.toString((InputStream)is, null));
    }
}

