/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.engine.DefaultPackageScanClassResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ReflectionInjector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JaxpTest {
    private static final Logger LOG = LoggerFactory.getLogger(JaxpTest.class);
    protected TypeConverter converter = new DefaultTypeConverter((PackageScanClassResolver)new DefaultPackageScanClassResolver(), (Injector)new ReflectionInjector(), false, false);

    @BeforeEach
    public void setUp() {
        ServiceHelper.startService((Object)this.converter);
    }

    @Test
    public void testConvertToDocument() {
        Document document = (Document)this.converter.convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>world!</hello>");
        Assertions.assertNotNull((Object)document);
        LOG.debug("Found document: {}", (Object)document);
        String text = (String)this.converter.convertTo(String.class, (Object)document);
        Assertions.assertTrue((boolean)text.endsWith("<hello>world!</hello>"), (String)("Converted to String: " + text));
    }

    @Test
    public void testConvertToSource() {
        Source source = (Source)this.converter.convertTo(Source.class, (Object)"<hello>world!</hello>");
        Assertions.assertNotNull((Object)source);
        LOG.debug("Found document: {}", (Object)source);
    }

    @Test
    public void testStreamSourceToDomSource() {
        StreamSource streamSource = new StreamSource(new StringReader("<hello>world!</hello>"));
        DOMSource domSource = (DOMSource)this.converter.convertTo(DOMSource.class, (Object)streamSource);
        Assertions.assertNotNull((Object)domSource, (String)"Could not convert to a DOMSource!");
        LOG.debug("Found document: {}", (Object)domSource);
    }

    @Test
    public void testNodeToSourceThenToInputStream() throws Exception {
        Document document = (Document)this.converter.convertTo(Document.class, (Object)"<?xml version=\"1.0\"?><hello>world!</hello>");
        Element element = document.getDocumentElement();
        Source source = (Source)this.converter.convertTo(DOMSource.class, (Object)element);
        Assertions.assertNotNull((Object)source, (String)"Could not convert from Node to Source!");
        LOG.debug("Found source: {}", (Object)source);
        InputStream in = (InputStream)this.converter.convertTo(InputStream.class, (Object)source);
        Assertions.assertNotNull((Object)in, (String)"Could not convert from Source to InputStream!");
        String actualText = IOConverter.toString((InputStream)in, null);
        Assertions.assertEquals((Object)"<hello>world!</hello>", (Object)actualText, (String)"Text");
    }
}

