/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Currency;
import java.util.Locale;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InstanceFallbackConverterTest
extends ContextTestSupport {
    @Override
    protected boolean isLoadTypeConverters() {
        return true;
    }

    @Test
    public void testInstanceFallbackConverter() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Currency cur = Currency.getInstance(Locale.US);
        String money = (String)this.context.getTypeConverter().convertTo(String.class, (Exchange)exchange, (Object)cur);
        Assertions.assertEquals((Object)("Money talks says " + this.context.getName()), (Object)money);
    }

    @Test
    public void testInstanceFallbackMandatoryConverter() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Currency cur = Currency.getInstance(Locale.US);
        String money = (String)this.context.getTypeConverter().mandatoryConvertTo(String.class, (Exchange)exchange, (Object)cur);
        Assertions.assertEquals((Object)("Money talks says " + this.context.getName()), (Object)money);
    }

    @Test
    public void testInstanceFallbackMandatoryFailed() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Assertions.assertThrows(NoTypeConversionAvailableException.class, () -> this.lambda$testInstanceFallbackMandatoryFailed$0((Exchange)exchange), (String)"Should have thrown an exception");
    }

    @Test
    public void testInstanceFallbackFailed() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Date out = (Date)this.context.getTypeConverter().convertTo(Date.class, (Exchange)exchange, (Object)new Timestamp(0L));
        Assertions.assertNull((Object)out);
    }

    private /* synthetic */ void lambda$testInstanceFallbackMandatoryFailed$0(Exchange exchange) throws Throwable {
        this.context.getTypeConverter().mandatoryConvertTo(Date.class, exchange, (Object)new Timestamp(0L));
    }
}

