/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOConverterTest
extends ContextTestSupport {
    public static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final byte[] TESTDATA = "My test data".getBytes();

    @Test
    public void testToBytes() throws Exception {
        File file = new File("src/test/resources/org/apache/camel/converter/dummy.txt");
        byte[] data = IOConverter.toBytes((InputStream)Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]));
        Assertions.assertEquals((long)file.length(), (long)data.length, (String)"get the wrong byte size");
        Assertions.assertEquals((int)35, (int)((char)data[0]));
        String s = new String(data);
        Assertions.assertTrue((boolean)s.contains("Hello World"), (String)"Should contain Hello World!");
    }

    @Test
    public void testCopy() throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(TESTDATA);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copy((InputStream)bis, (OutputStream)bos);
        Assertions.assertArrayEquals((byte[])TESTDATA, (byte[])bos.toByteArray());
    }

    @Test
    public void testToOutputStreamFile() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        File file = this.testFile(TEST_FILE_NAME).toFile();
        OutputStream os = IOConverter.toOutputStream((File)file);
        IOConverterTest.assertIsInstanceOf(BufferedOutputStream.class, os);
        os.close();
    }

    @Test
    public void testToWriterFile() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        File file = this.testFile(TEST_FILE_NAME).toFile();
        BufferedWriter writer = IOConverter.toWriter((File)file, null);
        IOConverterTest.assertIsInstanceOf(BufferedWriter.class, writer);
        ((Writer)writer).close();
    }

    @Test
    public void testToReader() throws Exception {
        Reader reader = IOConverter.toReader((String)"Hello");
        Assertions.assertEquals((Object)"Hello", (Object)IOConverter.toString((Reader)reader));
    }

    @Test
    public void testBytesToReader() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        String defaultCharacterSet = ObjectHelper.getDefaultCharacterSet();
        exchange.setProperty("CamelCharsetName", (Object)defaultCharacterSet);
        byte[] bytes = "Hello World".getBytes(defaultCharacterSet);
        Reader reader = IOConverter.toReader((byte[])bytes, (Exchange)exchange);
        Assertions.assertEquals((Object)"Hello World", (Object)IOConverter.toString((Reader)reader));
    }

    @Test
    public void testToInputStreamExchange() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setProperty("CamelCharsetName", (Object)ObjectHelper.getDefaultCharacterSet());
        InputStream is = IOConverter.toInputStream((String)"Hello World", (Exchange)exchange);
        Assertions.assertNotNull((Object)is);
        Assertions.assertEquals((Object)"Hello World", (Object)IOConverter.toString((InputStream)is, (Exchange)exchange));
    }

    @Test
    public void testToInputStreamStringBufferAndBuilderExchange() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setProperty("CamelCharsetName", (Object)ObjectHelper.getDefaultCharacterSet());
        StringBuffer buffer = new StringBuffer();
        buffer.append("Hello World");
        InputStream is = IOConverter.toInputStream((StringBuffer)buffer, (Exchange)exchange);
        Assertions.assertNotNull((Object)is);
        Assertions.assertEquals((Object)"Hello World", (Object)IOConverter.toString((InputStream)is, (Exchange)exchange));
        StringBuilder builder = new StringBuilder();
        builder.append("Hello World");
        is = IOConverter.toInputStream((StringBuilder)builder, (Exchange)exchange);
        Assertions.assertNotNull((Object)is);
        Assertions.assertEquals((Object)"Hello World", (Object)IOConverter.toString((InputStream)is, (Exchange)exchange));
    }

    @Test
    public void testToInputStreamBufferReader() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setProperty("CamelCharsetName", (Object)ObjectHelper.getDefaultCharacterSet());
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("Hello World"));
        InputStream is = IOConverter.toInputStream((BufferedReader)br, (Exchange)exchange);
        Assertions.assertNotNull((Object)is);
    }

    @Test
    public void testToByteArrayFile() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        File file = this.testFile(TEST_FILE_NAME).toFile();
        byte[] data = IOConverter.toByteArray((File)file);
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((int)11, (int)data.length);
    }

    @Test
    public void testToStringBufferReader() throws Exception {
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("Hello World"));
        String s = IOConverter.toString((BufferedReader)br);
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((Object)"Hello World", (Object)s);
    }

    @Test
    public void testToByteArrayBufferReader() throws Exception {
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("Hello World"));
        byte[] bytes = IOConverter.toByteArray((BufferedReader)br, null);
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)11, (int)bytes.length);
    }

    @Test
    public void testToByteArrayReader() throws Exception {
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("Hello World"));
        byte[] bytes = IOConverter.toByteArray((Reader)br, null);
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)11, (int)bytes.length);
    }

    @Test
    public void testToByteArrayOutputStream() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write("Hello World".getBytes());
        byte[] bytes = IOConverter.toByteArray((ByteArrayOutputStream)os);
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)11, (int)bytes.length);
    }

    @Test
    public void testToStringOutputStream() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write("Hello World".getBytes());
        String s = IOConverter.toString((ByteArrayOutputStream)os, null);
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((Object)"Hello World", (Object)s);
    }

    @Test
    public void testToInputStreamOutputStream() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write("Hello World".getBytes());
        InputStream is = IOConverter.toInputStream((ByteArrayOutputStream)os);
        Assertions.assertNotNull((Object)is);
        Assertions.assertEquals((Object)"Hello World", (Object)IOConverter.toString((InputStream)is, null));
    }

    @Test
    public void testToInputStreamUrl() throws Exception {
        URL url = ObjectHelper.loadResourceAsURL((String)"log4j2.properties");
        InputStream is = IOConverter.toInputStream((URL)url);
        IOConverterTest.assertIsInstanceOf(BufferedInputStream.class, is);
    }

    @Test
    public void testStringUrl() throws Exception {
        URL url = ObjectHelper.loadResourceAsURL((String)"log4j2.properties");
        String s = IOConverter.toString((URL)url, null);
        Assertions.assertNotNull((Object)s);
    }

    @Test
    public void testStringByBufferedReader() throws Exception {
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("Hello World"));
        Assertions.assertEquals((Object)"Hello World", (Object)IOConverter.toString((BufferedReader)br));
    }

    @Test
    public void testByteArrayByBufferedReader() throws Exception {
        StringReader reader = new StringReader("Hello World");
        byte[] data = IOConverter.toByteArray((Reader)reader, null);
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((Object)"Hello World", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)data));
    }

    @Test
    public void testInputStreamToString() throws Exception {
        String data = "46\u00b037'00\"N\"";
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setProperty("CamelCharsetName", (Object)"UTF-8");
        String result = IOConverter.toString((InputStream)is, (Exchange)exchange);
        Assertions.assertEquals((Object)data, (Object)result, (String)"Get a wrong result");
    }

    @Test
    public void testToPropertiesFromReader() throws Exception {
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("foo=123\nbar=456"));
        Properties p = IOConverter.toProperties((Reader)br);
        Assertions.assertNotNull((Object)p);
        Assertions.assertEquals((int)2, (int)p.size());
        Assertions.assertEquals((Object)"123", (Object)p.get("foo"));
        Assertions.assertEquals((Object)"456", (Object)p.get("bar"));
    }

    @Test
    public void testToPropertiesFromFile() throws Exception {
        Properties p = IOConverter.toProperties((File)new File("src/test/resources/log4j2.properties"));
        Assertions.assertNotNull((Object)p);
        Assertions.assertTrue((p.size() >= 8 ? 1 : 0) != 0, (String)("Should be 8 or more properties, was " + p.size()));
        String fn = (String)p.get("appender.file.fileName");
        Assertions.assertNotNull((Object)fn);
        Assertions.assertTrue((boolean)fn.contains("camel-core-test.log"));
    }

    @Test
    public void testToPathFromFile() {
        File file = new File("src/test/resources/log4j2.properties");
        Path p = IOConverter.toPath((File)file);
        Assertions.assertNotNull((Object)p);
        Assertions.assertEquals((Object)file.getName(), (Object)p.getFileName().toString());
        Assertions.assertEquals((Object)"log4j2.properties", (Object)p.getFileName().toString());
    }
}

