/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.sql.Timestamp;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class FutureConverterTest
extends ContextTestSupport {
    @Test
    public void testConvertFuture() {
        CompletableFuture future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)future);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
    }

    @Test
    public void testConvertMandatoryFuture() throws Exception {
        CompletableFuture future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        String out = (String)this.context.getTypeConverter().mandatoryConvertTo(String.class, (Object)future);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
    }

    @Test
    public void testConvertMandatoryFutureWithExchange() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        CompletableFuture future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        String out = (String)this.context.getTypeConverter().mandatoryConvertTo(String.class, (Exchange)exchange, (Object)future);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
    }

    @Test
    public void testConvertMandatoryFutureWithExchangeFailed() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        CompletableFuture future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        Assertions.assertThrows(NoTypeConversionAvailableException.class, () -> this.lambda$testConvertMandatoryFutureWithExchangeFailed$0((Exchange)exchange, future), (String)"Should have thrown an exception");
    }

    @Test
    public void testConvertFutureWithExchangeFailed() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        CompletableFuture future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        Timestamp out = (Timestamp)this.context.getTypeConverter().convertTo(Timestamp.class, (Exchange)exchange, (Object)future);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void testConvertFutureCancelled() {
        CompletableFuture future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        future.cancel(true);
        Object out = this.context.getTypeConverter().convertTo(String.class, (Object)future);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void testConvertFutureCancelledThenOkay() {
        CompletableFuture future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        future.cancel(true);
        Object out = this.context.getTypeConverter().convertTo(String.class, (Object)future);
        Assertions.assertNull((Object)out);
        future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        out = this.context.getTypeConverter().convertTo(String.class, (Object)future);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").delay(10L).transform((Expression)this.constant("Bye World"));
            }
        };
    }

    private /* synthetic */ void lambda$testConvertMandatoryFutureWithExchangeFailed$0(Exchange exchange, Future future) throws Throwable {
        this.context.getTypeConverter().mandatoryConvertTo(Timestamp.class, exchange, (Object)future);
    }
}

