/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TypeConversionException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.MyTypeEnum;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnumConverterTest
extends ContextTestSupport {
    @Test
    public void testMandatoryConvertEnum() throws Exception {
        LoggingLevel level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Object)"DEBUG");
        Assertions.assertEquals((Object)LoggingLevel.DEBUG, (Object)level);
    }

    @Test
    public void testMandatoryConvertWithExchangeEnum() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        LoggingLevel level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Exchange)exchange, (Object)"WARN");
        Assertions.assertEquals((Object)LoggingLevel.WARN, (Object)level);
    }

    @Test
    public void testCaseInsensitive() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        LoggingLevel level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Exchange)exchange, (Object)"Warn");
        Assertions.assertEquals((Object)LoggingLevel.WARN, (Object)level);
        level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Exchange)exchange, (Object)"warn");
        Assertions.assertEquals((Object)LoggingLevel.WARN, (Object)level);
        level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Exchange)exchange, (Object)"wARn");
        Assertions.assertEquals((Object)LoggingLevel.WARN, (Object)level);
        level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Exchange)exchange, (Object)"inFO");
        Assertions.assertEquals((Object)LoggingLevel.INFO, (Object)level);
    }

    @Test
    public void testMandatoryConvertFailed() {
        Assertions.assertThrows(TypeConversionException.class, () -> {
            LoggingLevel level = (LoggingLevel)this.context.getTypeConverter().convertTo(LoggingLevel.class, (Object)"XXX");
        }, (String)"Should have thrown an exception");
        Assertions.assertThrows(TypeConversionException.class, () -> this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Object)"XXX"), (String)"Should have thrown an exception");
    }

    @Test
    public void testCamelCash() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyEnum level = (MyEnum)((Object)this.context.getTypeConverter().mandatoryConvertTo(MyEnum.class, (Exchange)exchange, (Object)"GET_USERS"));
        Assertions.assertEquals((Object)((Object)MyEnum.GET_USERS), (Object)((Object)level));
        level = (MyEnum)((Object)this.context.getTypeConverter().mandatoryConvertTo(MyEnum.class, (Exchange)exchange, (Object)"getUsers"));
        Assertions.assertEquals((Object)((Object)MyEnum.GET_USERS), (Object)((Object)level));
        level = (MyEnum)((Object)this.context.getTypeConverter().mandatoryConvertTo(MyEnum.class, (Exchange)exchange, (Object)"getUsersByTopic"));
        Assertions.assertEquals((Object)((Object)MyEnum.GET_USERS_BY_TOPIC), (Object)((Object)level));
        level = (MyEnum)((Object)this.context.getTypeConverter().mandatoryConvertTo(MyEnum.class, (Exchange)exchange, (Object)"GetUsersByTopic"));
        Assertions.assertEquals((Object)((Object)MyEnum.GET_USERS_BY_TOPIC), (Object)((Object)level));
        level = (MyEnum)((Object)this.context.getTypeConverter().mandatoryConvertTo(MyEnum.class, (Exchange)exchange, (Object)"get-users-by-topic"));
        Assertions.assertEquals((Object)((Object)MyEnum.GET_USERS_BY_TOPIC), (Object)((Object)level));
        level = (MyEnum)((Object)this.context.getTypeConverter().mandatoryConvertTo(MyEnum.class, (Exchange)exchange, (Object)"Get-Users-By-Topic"));
        Assertions.assertEquals((Object)((Object)MyEnum.GET_USERS_BY_TOPIC), (Object)((Object)level));
    }

    @Test
    public void testConvertEnumWithToStringOverride() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyTypeEnum type = (MyTypeEnum)((Object)this.context.getTypeConverter().mandatoryConvertTo(MyTypeEnum.class, (Exchange)exchange, (Object)"TYPE1"));
        Assertions.assertSame((Object)((Object)MyTypeEnum.TYPE1), (Object)((Object)type));
        type = (MyTypeEnum)((Object)this.context.getTypeConverter().mandatoryConvertTo(MyTypeEnum.class, (Exchange)exchange, (Object)"TYPE2"));
        Assertions.assertSame((Object)((Object)MyTypeEnum.TYPE2), (Object)((Object)type));
        type = (MyTypeEnum)((Object)this.context.getTypeConverter().mandatoryConvertTo(MyTypeEnum.class, (Exchange)exchange, (Object)"TYPE3"));
        Assertions.assertSame((Object)((Object)MyTypeEnum.TYPE3), (Object)((Object)type));
    }

    @Test
    public void testEnumWithToStringOverrideRouteSimple() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)this.simple("${header.type} == ${type:org.apache.camel.converter.MyTypeEnum.TYPE1}")).to("mock:type1")).when((Predicate)this.simple("${header.type} == ${type:org.apache.camel.converter.MyTypeEnum.TYPE2}")).to("mock:type2")).when((Predicate)this.simple("${header.type} == ${type:org.apache.camel.converter.MyTypeEnum.TYPE3}")).to("mock:type3")).otherwise().to("mock:other");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:type1").expectedBodiesReceived(new Object[]{"C"});
        this.getMockEndpoint("mock:type2").expectedBodiesReceived(new Object[]{"A"});
        this.getMockEndpoint("mock:type3").expectedBodiesReceived(new Object[]{"B"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "type", (Object)MyTypeEnum.TYPE2);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "type", (Object)MyTypeEnum.TYPE3);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "type", (Object)MyTypeEnum.TYPE1);
        this.assertMockEndpointsSatisfied();
        this.context.stop();
    }

    public static enum MyEnum {
        GET_USERS,
        GET_USERS_BY_TOPIC;

    }
}

