/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.time.Duration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.TypeConversionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DurationConverterTest
extends ContextTestSupport {
    @Test
    public void testToMillis() {
        Duration duration = Duration.parse("PT2H6M20.31S");
        Long millis = (Long)this.context.getTypeConverter().convertTo(Long.TYPE, (Object)duration);
        Assertions.assertNotNull((Object)millis);
        MatcherAssert.assertThat((Object)millis, (Matcher)Is.is((Object)7580310L));
    }

    @Test
    public void testToMillisOverflow() {
        Duration duration = Duration.parse("P60000000000000D");
        TypeConversionException e = (TypeConversionException)Assertions.assertThrows(TypeConversionException.class, () -> this.context.getTypeConverter().convertTo(Long.TYPE, (Object)duration), (String)"Should throw exception");
        DurationConverterTest.assertIsInstanceOf(ArithmeticException.class, e.getCause());
    }

    @Test
    public void testFromString() {
        String durationAsString = "PT2H6M20.31S";
        Duration duration = (Duration)this.context.getTypeConverter().convertTo(Duration.class, (Object)durationAsString);
        Assertions.assertNotNull((Object)duration);
        MatcherAssert.assertThat((Object)duration.toString(), (Matcher)Is.is((Object)"PT2H6M20.31S"));
    }

    @Test
    public void testToString() {
        Duration duration = Duration.parse("PT2H6M20.31S");
        String durationAsString = (String)this.context.getTypeConverter().convertTo(String.class, (Object)duration);
        Assertions.assertNotNull((Object)durationAsString);
        MatcherAssert.assertThat((Object)durationAsString, (Matcher)Is.is((Object)"PT2H6M20.31S"));
    }
}

