/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateTimeConverterTest
extends ContextTestSupport {
    @Test
    public void testToTimeZone() {
        String id = TimeZone.getDefault().getID();
        TimeZone zone = (TimeZone)this.context.getTypeConverter().convertTo(TimeZone.class, (Object)id);
        Assertions.assertNotNull((Object)zone);
        Assertions.assertEquals((Object)id, (Object)zone.getID());
    }

    @Test
    public void testLongToDate() {
        long value = 0L;
        Date date = (Date)this.context.getTypeConverter().convertTo(Date.class, (Object)value);
        Date expected = new Date(value);
        Assertions.assertEquals((Object)expected, (Object)date);
    }

    @Test
    public void testDateToLong() {
        Date date = new Date(0L);
        long l = (Long)this.context.getTypeConverter().convertTo(Long.class, (Object)date);
        Assertions.assertEquals((long)date.getTime(), (long)l);
    }

    @Test
    public void testToTimeUnit() {
        Assertions.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)this.context.getTypeConverter().convertTo(TimeUnit.class, (Object)"DAYS"));
        Assertions.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)this.context.getTypeConverter().convertTo(TimeUnit.class, (Object)"MILLISECONDS"));
    }
}

