/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverters;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomEnumTypeConverterTest
extends ContextTestSupport {
    @Test
    public void testCustomEnumTypeConverterGetsCalled() {
        CustomEnumTypeConverter customEnumTypeConverter = new CustomEnumTypeConverter();
        this.context.getTypeConverterRegistry().addTypeConverters((Object)customEnumTypeConverter);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        StatusCodeEnum result = (StatusCodeEnum)((Object)this.context.getTypeConverter().convertTo(StatusCodeEnum.class, (Exchange)exchange, (Object)200));
        Assertions.assertEquals((Object)((Object)StatusCodeEnum.OK), (Object)((Object)result));
        result = (StatusCodeEnum)((Object)this.context.getTypeConverter().convertTo(StatusCodeEnum.class, (Exchange)exchange, (Object)404));
        Assertions.assertEquals((Object)((Object)StatusCodeEnum.NOT_FOUND), (Object)((Object)result));
    }

    public static class CustomEnumTypeConverter
    implements TypeConverters {
        @Converter
        public StatusCodeEnum toStatusCodeEnum(int i) {
            return StatusCodeEnum.fromCode(i);
        }
    }

    public static enum StatusCodeEnum {
        OK(200),
        NOT_FOUND(404);

        private final int statusCode;

        private StatusCodeEnum(int statusCode) {
            this.statusCode = statusCode;
        }

        static StatusCodeEnum fromCode(int statusCode) {
            switch (statusCode) {
                case 200: {
                    return OK;
                }
                case 404: {
                    return NOT_FOUND;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

