/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TestSupport;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.MyBean;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.engine.DefaultPackageScanClassResolver;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ReflectionInjector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterTest
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ConverterTest.class);
    protected final TypeConverter converter = new DefaultTypeConverter((PackageScanClassResolver)new DefaultPackageScanClassResolver(), (Injector)new ReflectionInjector(), true, false);

    @Override
    @BeforeEach
    public void setUp() {
        ServiceHelper.startService((Object)this.converter);
    }

    @Test
    public void testIntegerPropertyEditorConversion() {
        Integer value = (Integer)this.converter.convertTo(Integer.class, (Object)"1000");
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)1000, (Object)value, (String)"Converted to Integer");
        String text = (String)this.converter.convertTo(String.class, (Object)value);
        Assertions.assertEquals((Object)"1000", (Object)text, (String)"Converted to String");
    }

    @Test
    public void testConvertStringToAndFromByteArray() {
        byte[] array = (byte[])this.converter.convertTo(byte[].class, (Object)"foo");
        Assertions.assertNotNull((Object)array);
        LOG.debug("Found array of size: {}", (Object)array.length);
        String text = (String)this.converter.convertTo(String.class, (Object)array);
        Assertions.assertEquals((Object)"foo", (Object)text, (String)"Converted to String");
    }

    @Test
    public void testConvertStringToAndFromCharArray() {
        char[] array = (char[])this.converter.convertTo(char[].class, (Object)"foo");
        Assertions.assertNotNull((Object)array);
        LOG.debug("Found array of size: {}", (Object)array.length);
        String text = (String)this.converter.convertTo(String.class, (Object)array);
        Assertions.assertEquals((Object)"foo", (Object)text, (String)"Converted to String");
    }

    @Test
    public void testConvertStringAndStreams() {
        InputStream inputStream = (InputStream)this.converter.convertTo(InputStream.class, (Object)"bar");
        Assertions.assertNotNull((Object)inputStream);
        String text = (String)this.converter.convertTo(String.class, (Object)inputStream);
        Assertions.assertEquals((Object)"bar", (Object)text, (String)"Converted to String");
    }

    @Test
    public void testArrayToListAndSetConversion() {
        String[] array = new String[]{"one", "two"};
        List list = (List)this.converter.convertTo(List.class, (Object)array);
        Assertions.assertEquals((int)2, (int)list.size(), (String)("List size: " + String.valueOf(list)));
        Collection collection = (Collection)this.converter.convertTo(Collection.class, (Object)array);
        Assertions.assertNotNull((Object)collection, (String)"Returned object must not be null");
        Assertions.assertEquals((int)2, (int)collection.size(), (String)("Collection size: " + String.valueOf(collection)));
        Set set = (Set)this.converter.convertTo(Set.class, (Object)list);
        Assertions.assertEquals((int)2, (int)set.size(), (String)("Set size: " + String.valueOf(set)));
    }

    @Test
    public void testCollectionToArrayConversion() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        Object[] objectArray = (Object[])this.converter.convertTo(Object[].class, list);
        Assertions.assertEquals((int)2, (int)objectArray.length, (String)"Object[] length");
        String[] stringArray = (String[])this.converter.convertTo(String[].class, list);
        Assertions.assertEquals((int)2, (int)stringArray.length, (String)"String[] length");
    }

    @Test
    public void testCollectionToPrimitiveArrayConversion() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(5);
        list.add(6);
        Integer[] integerArray = (Integer[])this.converter.convertTo(Integer[].class, list);
        Assertions.assertEquals((int)2, (int)integerArray.length, (String)"Integer[] length");
        int[] intArray = (int[])this.converter.convertTo(int[].class, list);
        Assertions.assertEquals((int)2, (int)intArray.length, (String)"int[] length");
        long[] longArray = (long[])this.converter.convertTo(long[].class, (Object)intArray);
        Assertions.assertEquals((int)2, (int)longArray.length, (String)"long[] length");
        List resultList = (List)this.converter.convertTo(List.class, (Object)intArray);
        Assertions.assertEquals((int)2, (int)resultList.size(), (String)"List size");
        LOG.debug("From primitive type array we've created the list: {}", (Object)resultList);
    }

    @Test
    public void testFileToString() {
        URL resource = this.getClass().getResource("dummy.txt");
        Assertions.assertNotNull((Object)resource, (String)"Cannot find resource!");
        File file = new File(URLDecoder.decode(resource.getFile(), StandardCharsets.UTF_8));
        String text = (String)this.converter.convertTo(String.class, (Object)file);
        Assertions.assertNotNull((Object)text, (String)"Should have returned a String!");
        text = text.trim();
        Assertions.assertTrue((boolean)text.endsWith("Hello World!"), (String)("Text not read correctly: " + text));
    }

    @Test
    public void testPrimitiveBooleanConversion() {
        boolean value = (Boolean)Assertions.assertDoesNotThrow(() -> (Boolean)this.converter.convertTo(Boolean.TYPE, null), (String)"A conversion from primitive boolean must not throw when receiving a null value");
        Assertions.assertFalse((boolean)value, (String)"A conversion from primitive boolean must default to false when converting from null");
    }

    @Test
    public void testPrimitiveIntConversion() {
        int value = (Integer)this.converter.convertTo(Integer.TYPE, (Object)4);
        Assertions.assertEquals((int)4, (int)value, (String)"value");
    }

    @Test
    public void testPrimitiveIntPropertySetter() {
        MyBean bean = new MyBean();
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)context);
        Assertions.assertDoesNotThrow(() -> this.lambda$testPrimitiveIntPropertySetter$1(bi, (CamelContext)context, bean), (String)"Setting an int property in a bean, should have succeeded without throwing exceptions");
        Assertions.assertEquals((int)4, (int)bean.getFoo(), (String)"The property bean.foo does not match the value that was previously set");
        context.stop();
    }

    @Test
    public void testStringToBoolean() {
        Boolean value = (Boolean)this.converter.convertTo(Boolean.class, (Object)"true");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)value, (String)"converted boolean value");
        value = (Boolean)this.converter.convertTo(Boolean.class, (Object)"false");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)value, (String)"converted boolean value");
        value = (Boolean)this.converter.convertTo(Boolean.class, null);
        Assertions.assertNull((Object)value, (String)"converted boolean value");
    }

    @Test
    public void testStaticMethodConversionWithExchange() {
        DefaultCamelContext camel = new DefaultCamelContext();
        DefaultExchange e = new DefaultExchange((CamelContext)camel);
        e.setProperty("prefix", (Object)"foo-");
        MyBean bean = (MyBean)this.converter.convertTo(MyBean.class, (Exchange)e, (Object)"5:bar");
        Assertions.assertEquals((int)5, (int)bean.getFoo(), (String)"converted using exchange");
        Assertions.assertEquals((Object)"foo-bar", (Object)bean.getBar(), (String)"converted using exchange");
    }

    @Test
    public void testInstanceMethodConversionWithExchange() {
        String[] values = new String[]{"5", "bar"};
        DefaultCamelContext camel = new DefaultCamelContext();
        DefaultExchange e = new DefaultExchange((CamelContext)camel);
        e.setProperty("prefix", (Object)"foo-");
        MyBean bean = (MyBean)this.converter.convertTo(MyBean.class, (Exchange)e, (Object)values);
        Assertions.assertEquals((int)5, (int)bean.getFoo(), (String)"converted using exchange");
        Assertions.assertEquals((Object)"foo-bar", (Object)bean.getBar(), (String)"converted using exchange");
    }

    @Test
    public void testMandatoryConvertTo() {
        DefaultCamelContext camel = new DefaultCamelContext();
        DefaultExchange exchange = new DefaultExchange((CamelContext)camel);
        Assertions.assertThrows(NoTypeConversionAvailableException.class, () -> this.lambda$testMandatoryConvertTo$2((Exchange)exchange), (String)"Expected to get a NoTypeConversionAvailableException here");
    }

    @Test
    public void testStringToChar() {
        char ch = ((Character)Assertions.assertDoesNotThrow(() -> (Character)this.converter.convertTo(Character.TYPE, (Object)"A"), (String)"A conversion from String to char should have succeeded without throwing exceptions")).charValue();
        Assertions.assertEquals((int)65, (int)ch, (String)"The converted value does not match what was set");
        ch = ((Character)Assertions.assertDoesNotThrow(() -> (Character)this.converter.convertTo(Character.TYPE, (Object)" "), (String)"A conversion from String with spaces to char should have succeeded without throwing exceptions")).charValue();
        Assertions.assertEquals((int)32, (int)ch, (String)"The converted value does not match what was set");
        Exception ex = (Exception)Assertions.assertThrows(TypeConversionException.class, () -> this.converter.mandatoryConvertTo(Character.TYPE, (Object)"ABC"), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"String must have exactly a length of 1: ABC", (Object)ex.getCause().getMessage());
    }

    @Test
    public void testNullToBoolean() {
        boolean b = (Boolean)this.converter.convertTo(Boolean.TYPE, null);
        Assertions.assertFalse((boolean)b);
    }

    @Test
    public void testNullToInt() {
        int i = (Integer)this.converter.convertTo(Integer.TYPE, null);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void testToInt() {
        int i = (Integer)this.converter.convertTo(Integer.TYPE, (Object)"0");
        Assertions.assertEquals((int)0, (int)i);
    }

    private /* synthetic */ void lambda$testMandatoryConvertTo$2(Exchange exchange) throws Throwable {
        this.converter.mandatoryConvertTo(InputStream.class, (Object)exchange);
    }

    private /* synthetic */ Boolean lambda$testPrimitiveIntPropertySetter$1(BeanIntrospection bi, CamelContext context, MyBean bean) throws Throwable {
        return bi.setProperty(context, this.converter, (Object)bean, "foo", (Object)"4", null, true, true, true);
    }
}

