/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.converter.CollectionConverter;
import org.apache.camel.util.CaseInsensitiveMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CollectionConverterTest {
    private static final List<String> SMURFS = Arrays.asList("Papa smurf", "Smurfette", "Hefty smurf", "Jokey smurf");

    @Test
    public void testIteratorToList() {
        this.assertSmurfs(CollectionConverter.toArrayList(SMURFS.iterator()));
    }

    @Test
    public void testIterableToList() {
        this.assertSmurfs(CollectionConverter.toList((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return SMURFS.iterator();
            }
        }));
        Assertions.assertSame(SMURFS, (Object)CollectionConverter.toList(SMURFS));
    }

    private void assertSmurfs(Collection<String> result) {
        Assertions.assertEquals((int)SMURFS.size(), (int)result.size());
        for (String key : result) {
            Assertions.assertTrue((boolean)SMURFS.contains(key));
        }
    }

    @Test
    public void testToArray() {
        Object[] data = CollectionConverter.toArray(SMURFS);
        Assertions.assertEquals((int)4, (int)data.length);
    }

    @Test
    public void testToList() {
        List out = CollectionConverter.toList(SMURFS);
        Assertions.assertEquals((int)4, (int)out.size());
    }

    @Test
    public void testToSet() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        Set out = CollectionConverter.toSet(map);
        Assertions.assertEquals((int)1, (int)out.size());
    }

    @Test
    public void testToHashMap() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("foo", "bar");
        HashMap out = CollectionConverter.toHashMap((Map)map);
        Assertions.assertEquals((int)1, (int)out.size());
    }

    @Test
    public void testToHashtable() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("foo", "bar");
        Hashtable out = CollectionConverter.toHashtable((Map)map);
        Assertions.assertEquals((int)1, (int)out.size());
    }

    @Test
    public void testToProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        Properties prop = CollectionConverter.toProperties(map);
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((int)1, (int)prop.size());
        Assertions.assertEquals((Object)"bar", (Object)prop.get("foo"));
    }
}

