/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.converter.CamelConverter;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CamelConverterTest
extends ContextTestSupport {
    @Test
    public void testToProcessorExpression() throws Exception {
        Expression exp = ExpressionBuilder.headerExpression((String)"foo");
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("foo", (Object)"bar");
        exchange.getIn().setBody((Object)"Hello World");
        Processor pro = CamelConverter.toProcessor((Expression)exp);
        pro.process((Exchange)exchange);
        Assertions.assertEquals((Object)"bar", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void testToProcessorPredicate() throws Exception {
        Predicate pred = PredicateBuilder.isEqualTo((Expression)ExpressionBuilder.headerExpression((String)"foo"), (Expression)Builder.constant((Object)"bar"));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("foo", (Object)"bar");
        exchange.getIn().setBody((Object)"Hello World");
        Processor pro = CamelConverter.toProcessor((Predicate)pred);
        pro.process((Exchange)exchange);
        Assertions.assertEquals((Object)true, (Object)exchange.getMessage().getBody());
    }
}

