/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.impl.converter.EnumTypeConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BasicEnumConverterTest {
    private final EnumTypeConverter converter = new EnumTypeConverter();

    @Test
    public void testConvertFromString() {
        StatusCodeEnum code = (StatusCodeEnum)((Object)this.converter.convertTo(StatusCodeEnum.class, (Object)"OK"));
        Assertions.assertEquals((Object)((Object)StatusCodeEnum.OK), (Object)((Object)code), (String)"String should be converted to corresponding Enum value");
    }

    @Test
    public void testConvertFromStringCaseInsensitive() {
        StatusCodeEnum code = (StatusCodeEnum)((Object)this.converter.convertTo(StatusCodeEnum.class, (Object)"ok"));
        Assertions.assertEquals((Object)((Object)StatusCodeEnum.OK), (Object)((Object)code), (String)"Lower case string should be converted to corresponding Enum value");
    }

    @Test
    public void testConvertFromCamelCasedString() {
        StatusCodeEnum code = (StatusCodeEnum)((Object)this.converter.convertTo(StatusCodeEnum.class, (Object)"NotFound"));
        Assertions.assertEquals((Object)((Object)StatusCodeEnum.NOT_FOUND), (Object)((Object)code), (String)"Camel cased string should be converted to corresponding Enum value");
    }

    @Test
    public void testConvertFromDashedString() {
        StatusCodeEnum code = (StatusCodeEnum)((Object)this.converter.convertTo(StatusCodeEnum.class, (Object)"not-found"));
        Assertions.assertEquals((Object)((Object)StatusCodeEnum.NOT_FOUND), (Object)((Object)code), (String)"Dashed string should be converted to corresponding Enum value");
    }

    private static enum StatusCodeEnum {
        OK,
        NOT_FOUND;

    }
}

