/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.component.xslt.XsltUriResolver;
import org.apache.camel.component.xslt.XsltUriResolverFactory;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.jndi.JndiBeanRepository;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltUriResolverFactoryTest
extends ContextTestSupport {
    private Context jndiContext;

    @Test
    public void testConfigurationOnEndpoint() throws Exception {
        String endpointUri = "xslt:xslt/staff/staff.xsl?uriResolverFactory=#uriResolverFactory";
        String directStart = "direct:start";
        this.jndiContext.unbind("xslt");
        this.execute(endpointUri, directStart);
    }

    @Test
    public void testConfigurationOnComponent() throws Exception {
        XsltComponent xsltComponent = new XsltComponent();
        xsltComponent.setUriResolverFactory((XsltUriResolverFactory)new CustomXsltUriResolverFactory());
        this.jndiContext.bind("xslt", (Object)xsltComponent);
        String endpointUri = "xslt:xslt/staff/staff.xsl";
        String directStart = "direct:startComponent";
        this.execute(endpointUri, directStart);
    }

    void execute(String endpointUri, String directStart) throws InterruptedException {
        InputStream payloud = XsltUriResolverFactoryTest.class.getClassLoader().getResourceAsStream("xslt/staff/staff.xml");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.sendBody(directStart, payloud);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> this.resolveMandatoryEndpoint(endpointUri, XsltEndpoint.class) != null);
        this.assertMockEndpointsSatisfied();
        XsltEndpoint xsltEndpoint = this.resolveMandatoryEndpoint(endpointUri, XsltEndpoint.class);
        Assertions.assertNotNull((Object)xsltEndpoint);
        CustomXsltUriResolver resolver = (CustomXsltUriResolver)((Object)xsltEndpoint.getUriResolver());
        this.checkResourceUri(resolver.resolvedResourceUris, "xslt/staff/staff.xsl");
        this.checkResourceUri(resolver.resolvedResourceUris, "../common/staff_template.xsl");
    }

    protected RouteBuilder[] createRouteBuilders() {
        return new RouteBuilder[]{new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setHeader("xslt_file", (Expression)new ConstantExpression("xslt/staff/staff.xsl"))).recipientList((Expression)new SimpleExpression("xslt:${header.xslt_file}?uriResolverFactory=#uriResolverFactory")).to("mock:result");
            }
        }, new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:startComponent").setHeader("xslt_file", (Expression)new ConstantExpression("xslt/staff/staff.xsl"))).recipientList((Expression)new SimpleExpression("xslt:${header.xslt_file}")).to("mock:result");
            }
        }};
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        this.jndiContext = this.createJndiContext();
        this.jndiContext.bind("uriResolverFactory", (Object)new CustomXsltUriResolverFactory());
        return new DefaultRegistry(new BeanRepository[]{new JndiBeanRepository(this.jndiContext)});
    }

    void checkResourceUri(Set<String> uris, String resourceUri) {
        Assertions.assertTrue((boolean)uris.contains(resourceUri), (String)("Missing resource uri " + resourceUri + " in resolved resource URI set"));
    }

    static class CustomXsltUriResolverFactory
    implements XsltUriResolverFactory {
        CustomXsltUriResolverFactory() {
        }

        public URIResolver createUriResolver(CamelContext camelContext, String resourceUri) {
            return new CustomXsltUriResolver(camelContext, resourceUri);
        }
    }

    static class CustomXsltUriResolver
    extends XsltUriResolver {
        private final Set<String> resolvedResourceUris = new HashSet<String>();

        CustomXsltUriResolver(CamelContext context, String location) {
            super(context, location);
        }

        public Source resolve(String href, String base) throws TransformerException {
            Source result = super.resolve(href, base);
            this.resolvedResourceUris.add(href);
            return result;
        }
    }
}

