/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import javax.xml.transform.TransformerException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltTransformingExceptionTest
extends ContextTestSupport {
    private static final String GOOD_XML_STRING = "<name>Camel</name>";
    private static final String BAD_XML_STRING = "<staff><programmer></programmer></staff>";

    @Test
    public void testXsltException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        CamelExecutionException ex = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)BAD_XML_STRING), (String)"Except a camel Execution exception here");
        boolean b = ex.getCause() instanceof TransformerException;
        Assertions.assertTrue((boolean)b);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testXsltWithoutException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)GOOD_XML_STRING);
            Assertions.fail((String)"Except a camel Execution exception here");
        }
        catch (CamelExecutionException ex) {
            boolean b = ex.getCause() instanceof TransformerException;
            Assertions.assertTrue((boolean)b);
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/transformCallEcho.xsl")).to("mock:result");
            }
        };
    }
}

