/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.InputStream;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.xslt.TestBean;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.IOHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltTemplateFromHeaderOverrideEndpointUriTest
extends ContextTestSupport {
    @Test
    public void testSendMessageAndHaveItTransformed() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.expectedMessageCount(1);
        String sheet = IOHelper.loadText((InputStream)XsltTemplateFromHeaderOverrideEndpointUriTest.class.getResourceAsStream("/org/apache/camel/component/xslt/transform_to_foo.xsl"));
        Assertions.assertNotNull((Object)sheet);
        this.template.sendBodyAndHeader("direct:start", (Object)"<mail><subject>Hey</subject><body>Hello world!</body></mail>", "CamelXsltStylesheet", (Object)sheet);
        this.assertMockEndpointsSatisfied();
        List list = endpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        String xml = (String)exchange.getIn().getBody(String.class);
        Assertions.assertNotNull((Object)xml, (String)"The transformed XML should not be null");
        Assertions.assertTrue((boolean)xml.contains("transformed"));
        Assertions.assertTrue((boolean)xml.contains("foo"));
        Assertions.assertTrue((boolean)xml.contains("<subject>Hey</subject>"));
        Assertions.assertTrue((boolean)xml.contains("<body>Hello world!</body>"));
        TestBean bean = (TestBean)this.context.getRegistry().lookupByNameAndType("testBean", TestBean.class);
        Assertions.assertNotNull((Object)bean);
        Assertions.assertEquals((Object)"Hey", (Object)bean.getSubject());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)((RouteDefinition)this.from("direct:start").to("xslt:dummy.xsl?contentCache=false&allowTemplateFromHeader=true")).multicast().bean((Object)"testBean")).to("mock:result");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("testBean", (Object)new TestBean());
        return context;
    }
}

