/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.xslt.TestBean;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

public class XsltRouteTest
extends ContextTestSupport {
    @Test
    public void testSendStringMessage() throws Exception {
        this.sendMessageAndHaveItTransformed("<mail><subject>Hey</subject><body>Hello world!</body></mail>");
    }

    @Test
    public void testSendBytesMessage() throws Exception {
        this.sendMessageAndHaveItTransformed("<mail><subject>Hey</subject><body>Hello world!</body></mail>".getBytes());
    }

    @Test
    public void testSendDomMessage() throws Exception {
        XmlConverter converter = new XmlConverter();
        Document body = converter.toDOMDocument("<mail><subject>Hey</subject><body>Hello world!</body></mail>", null);
        this.sendMessageAndHaveItTransformed(body);
    }

    private void sendMessageAndHaveItTransformed(Object body) throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", body);
        this.assertMockEndpointsSatisfied();
        List list = endpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        String xml = (String)exchange.getIn().getBody(String.class);
        Assertions.assertNotNull((Object)xml, (String)"The transformed XML should not be null");
        Assertions.assertTrue((xml.indexOf("transformed") > -1 ? 1 : 0) != 0);
        Assertions.assertTrue((xml.indexOf("cheese") > -1 ? 1 : 0) != 0);
        Assertions.assertTrue((xml.indexOf("<subject>Hey</subject>") > -1 ? 1 : 0) != 0);
        Assertions.assertTrue((xml.indexOf("<body>Hello world!</body>") > -1 ? 1 : 0) != 0);
        TestBean bean = (TestBean)this.context.getRegistry().lookupByNameAndType("testBean", TestBean.class);
        Assertions.assertNotNull((Object)bean);
        Assertions.assertEquals((Object)"Hey", (Object)bean.getSubject(), (String)"bean.subject");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/transform.xsl")).multicast().bean((Object)"testBean")).to("mock:result");
            }
        };
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("testBean", (Object)new TestBean());
        return jndi;
    }
}

