/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.xslt.DomResultHandlerFactory;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltResultHandlerTest
extends TestSupport {
    @Test
    public void testResultHandlerFactory() throws Exception {
        RouteBuilder builder = this.createRouteBuilder();
        DefaultCamelContext context = new DefaultCamelContext();
        DomResultHandlerFactory factory = new DomResultHandlerFactory();
        context.getRegistry().bind("factory", (Object)factory);
        context.addRoutes((RoutesBuilder)builder);
        context.start();
        XsltEndpoint endpoint = null;
        for (Endpoint ep : context.getEndpoints()) {
            XsltEndpoint xsltEndpoint;
            if (!(ep instanceof XsltEndpoint)) continue;
            endpoint = xsltEndpoint = (XsltEndpoint)ep;
            break;
        }
        Assertions.assertNotNull(endpoint);
        Assertions.assertEquals(DomResultHandlerFactory.class, (Object)factory.getClass());
        Assertions.assertEquals((Object)factory, (Object)endpoint.getResultHandlerFactory());
        Assertions.assertEquals((Object)factory, (Object)endpoint.getXslt().getResultHandlerFactory());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("xslt:org/apache/camel/component/xslt/example.xsl?output=bytes&resultHandlerFactory=#factory");
            }
        };
    }
}

