/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.File;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltOutputFileTest
extends ContextTestSupport {
    @Test
    public void testXsltOutput() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        mock.expectedFileExists(this.testFile("xsltme.xml"));
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(File.class);
        this.template.sendBodyAndHeader("direct:start", (Object)"<hello>world!</hello>", "CamelXsltFileName", (Object)this.testFile("xsltme.xml").toString());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testXsltOutputFileMissingHeader() {
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"<hello>world!</hello>"), (String)"Should thrown exception");
        NoSuchHeaderException nshe = XsltOutputFileTest.assertIsInstanceOf(NoSuchHeaderException.class, e.getCause());
        Assertions.assertEquals((Object)"CamelXsltFileName", (Object)nshe.getHeaderName());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/example.xsl?output=file")).to("mock:result");
            }
        };
    }
}

