/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class XsltOutputFileDeleteTest
extends ContextTestSupport {
    @Test
    public void testXsltOutputDeleteFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBodyAndHeader("direct:start", (Object)"<hello>world!</hello>", "CamelXsltFileName", (Object)this.testFile("xsltme.xml").toString());
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        XsltOutputFileDeleteTest.assertFileNotExists(this.testFile("xsltme.xml"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/example.xsl?output=file&deleteOutputFile=true")).to("mock:result");
            }
        };
    }
}

