/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltMessageTerminateTest
extends ContextTestSupport {
    @Test
    public void testXsltTerminate() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
        Exchange out = (Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0);
        Assertions.assertNotNull((Object)out);
        Exception cause = (Exception)out.getProperty("CamelExceptionCaught", Exception.class);
        Assertions.assertNotNull((Object)cause);
        Exception warning = (Exception)out.getProperty("CamelXsltWarning", Exception.class);
        Assertions.assertNotNull((Object)warning);
        Assertions.assertEquals((Object)"Error: DOB is an empty string!", (Object)warning.getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)((RouteDefinition)this.from("file:src/test/data/?fileName=terminate.xml&noop=true&initialDelay=0&delay=10").to("xslt:org/apache/camel/component/xslt/terminate.xsl")).to("log:foo")).to("mock:result");
            }
        };
    }
}

