/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.xslt.TestBean;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltFromHeaderOverrideEndpointUriTest
extends ContextTestSupport {
    @Test
    public void testSendMessageAndHaveItTransformed() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"<mail><subject>Hey</subject><body>Hello world!</body></mail>", "CamelXsltResourceUri", (Object)"org/apache/camel/component/xslt/transform_to_foo.xsl");
        this.assertMockEndpointsSatisfied();
        List list = endpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        String xml = (String)exchange.getIn().getBody(String.class);
        Assertions.assertNotNull((Object)xml, (String)"The transformed XML should not be null");
        Assertions.assertTrue((boolean)xml.contains("transformed"));
        Assertions.assertTrue((boolean)xml.contains("foo"));
        Assertions.assertTrue((boolean)xml.contains("<subject>Hey</subject>"));
        Assertions.assertTrue((boolean)xml.contains("<body>Hello world!</body>"));
        TestBean bean = (TestBean)this.context.getRegistry().lookupByNameAndType("testBean", TestBean.class);
        Assertions.assertNotNull((Object)bean);
        Assertions.assertEquals((Object)"Hey", (Object)bean.getSubject());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/transform.xsl?allowTemplateFromHeader=true")).multicast().bean((Object)"testBean")).to("mock:result");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("testBean", (Object)new TestBean());
        return context;
    }
}

