/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Test;

public class XsltFromFileExceptionTest
extends ContextTestSupport {
    @Test
    public void testXsltFromFileExceptionOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<hello>world!</hello>", "CamelFileName", (Object)"hello.xml");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        XsltFromFileExceptionTest.assertFileNotExists(this.testFile("hello.xml"));
        XsltFromFileExceptionTest.assertFileExists(this.testFile("ok/hello.xml"));
    }

    @Test
    public void testXsltFromFileExceptionFail() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<hello>world!</hello", "CamelFileName", (Object)"hello2.xml");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        XsltFromFileExceptionTest.assertFileNotExists(this.testFile("hello2.xml"));
        XsltFromFileExceptionTest.assertFileExists(this.testFile("error/hello2.xml"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.from(XsltFromFileExceptionTest.this.fileUri("?moveFailed=error&move=ok&initialDelay=0&delay=10")).onException(Exception.class).to("mock:error")).end().to("xslt:org/apache/camel/component/xslt/example.xsl").to("mock:result");
            }
        };
    }
}

