/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import javax.xml.transform.TransformerException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltFeatureRouteTest
extends ContextTestSupport {
    @Test
    public void testSendMessage() {
        String message = "<hello/>";
        this.sendXmlMessage("direct:start1", message);
        this.sendXmlMessage("direct:start2", message);
    }

    public void sendXmlMessage(String uri, String message) {
        Exception ex = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start1", (Object)message), (String)"Expected an exception here");
        boolean b1 = ex instanceof CamelExecutionException;
        Assertions.assertTrue((boolean)b1, (String)"Get a wrong exception");
        boolean b = ex.getCause() instanceof TransformerException;
        Assertions.assertTrue((boolean)b, (String)"Get a wrong exception cause");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start1").to("xslt:org/apache/camel/component/xslt/transform_text_imported.xsl")).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").to("xslt:org/apache/camel/component/xslt/transform_text.xsl")).to("mock:result");
            }
        };
    }
}

