/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.InputStream;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltDTDTest
extends ContextTestSupport {
    private static final String MESSAGE = "<!DOCTYPE foo [<!ENTITY xxe SYSTEM \"file:///etc//user//test\">]><task><name>&xxe;</name></task>";

    @Test
    public void testSendingStringMessage() throws Exception {
        this.sendEntityMessage(MESSAGE);
    }

    @Test
    public void testSendingInputStreamMessage() throws Exception {
        InputStream is = IOConverter.toInputStream((String)MESSAGE, (Exchange)new DefaultExchange((CamelContext)this.context));
        this.sendEntityMessage(is);
    }

    private void sendEntityMessage(Object message) throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.reset();
        endpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start1", message);
        this.assertMockEndpointsSatisfied();
        List list = endpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        String xml = (String)exchange.getIn().getBody(String.class);
        Assertions.assertTrue((xml.indexOf("<transformed subject=\"\">") > 0 ? 1 : 0) != 0, (String)"Get a wrong transformed message");
        try {
            endpoint.reset();
            endpoint.expectedMessageCount(1);
            this.template.sendBody("direct:start2", message);
            this.assertMockEndpointsSatisfied();
            list = endpoint.getReceivedExchanges();
            exchange = (Exchange)list.get(0);
            xml = (String)exchange.getIn().getBody(String.class);
            Assertions.assertTrue((xml.indexOf("<transformed subject=\"\">") > 0 ? 1 : 0) != 0, (String)"Get a wrong transformed message");
        }
        catch (Exception ex) {
            boolean b1 = ex instanceof CamelExecutionException;
            Assertions.assertTrue((boolean)b1, (String)"Get a wrong exception");
            boolean b = ex.getCause() instanceof TransformerException;
            Assertions.assertTrue((boolean)b, (String)"Get a wrong exception cause");
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start1").to("xslt:org/apache/camel/component/xslt/transform_dtd.xsl")).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").to("xslt:org/apache/camel/component/xslt/transform_dtd.xsl")).to("mock:result");
            }
        };
    }
}

