/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.StringReader;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class XsltCustomizeEntityResolverTest
extends ContextTestSupport {
    private static final String EXPECTED_XML_CONSTANT = "<A>1</A>";

    @Test
    public void testXsltCustomURIResolverDirectInRouteUri() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:resultURIResolverDirect");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).contains((Object)EXPECTED_XML_CONSTANT);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("file:src/test/data/?fileName=xml_with_entity.xml&noop=true&initialDelay=0&delay=10").to("xslt:xslt/common/copy.xsl?output=string&entityResolver=#customEntityResolver")).to("mock:resultURIResolverDirect");
            }
        };
    }

    private EntityResolver getCustomEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                return new InputSource(new StringReader("<!ELEMENT A (#PCDATA)>"));
            }
        };
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        EntityResolver customEntityResolver = this.getCustomEntityResolver();
        registry.bind("customEntityResolver", (Object)customEntityResolver);
        return registry;
    }
}

