/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltCustomErrorListenerTest
extends TestSupport {
    private final MyErrorListener listener = new MyErrorListener();

    @Test
    public void testErrorListener() throws Exception {
        RouteBuilder builder = this.createRouteBuilder();
        DefaultCamelContext context = new DefaultCamelContext();
        context.getRegistry().bind("myListener", (Object)this.listener);
        context.addRoutes((RoutesBuilder)builder);
        Assertions.assertThrows(RuntimeCamelException.class, () -> XsltCustomErrorListenerTest.lambda$testErrorListener$0((CamelContext)context));
        Assertions.assertFalse((boolean)this.listener.isWarning());
        Assertions.assertTrue((boolean)this.listener.isError(), (String)"My error listener should been invoked");
        Assertions.assertTrue((boolean)this.listener.isFatalError(), (String)"My error listener should been invoked");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:a").to("xslt:org/apache/camel/builder/xml/example-with-errors.xsl?errorListener=#myListener");
            }
        };
    }

    private static /* synthetic */ void lambda$testErrorListener$0(CamelContext context) throws Throwable {
        context.start();
    }

    private static class MyErrorListener
    implements ErrorListener {
        private boolean warning;
        private boolean error;
        private boolean fatalError;

        private MyErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            this.warning = true;
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            this.error = true;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            this.fatalError = true;
        }

        public boolean isWarning() {
            return this.warning;
        }

        public boolean isError() {
            return this.error;
        }

        public boolean isFatalError() {
            return this.fatalError;
        }
    }
}

