/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValidatorWithDirectTest
extends ContextTestSupport {
    final String wrongBody = "<user2><name>Federico</name><surname>Mariani</surname></user2>";

    @Test
    public void testValidatorWithDirect() throws Exception {
        MockEndpoint valid = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        MockEndpoint fail = this.resolveMandatoryEndpoint("mock:fail", MockEndpoint.class);
        fail.expectedMessageCount(1);
        valid.expectedMessageCount(0);
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"<user2><name>Federico</name><surname>Mariani</surname></user2>"), (String)"Should throw exception");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).to("mock:fail");
                this.validator().type("xml:schemaValidator").withUri("validator:org/apache/camel/impl/validate.xsd?failOnNullBody=false");
                this.from("direct:start").inputTypeWithValidate("xml:schemaValidator").to("mock:valid");
            }
        };
    }
}

