/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.support.processor.validation.NoXmlHeaderValidationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidatorRouteTest
extends ContextTestSupport {
    protected MockEndpoint validEndpoint;
    protected MockEndpoint finallyEndpoint;
    protected MockEndpoint invalidEndpoint;

    @Test
    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Test
    public void testValidMessageInHeader() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:startHeaders", null, "headerToValidate", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Test
    public void testInvalidMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Test
    public void testInvalidMessageInHeader() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:startHeaders", null, "headerToValidate", (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Test
    public void testNullHeaderNoFail() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:startNullHeaderNoFail", null, "headerToValidate", null);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint});
    }

    @Test
    public void testNullHeader() throws Exception {
        this.validEndpoint.setExpectedMessageCount(0);
        Exchange in = this.resolveMandatoryEndpoint("direct:startNoHeaderException").createExchange(ExchangePattern.InOut);
        in.getIn().setBody(null);
        in.getIn().setHeader("headerToValidate", null);
        Exchange out = this.template.send("direct:startNoHeaderException", in);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
        Exception exception = out.getException();
        Assertions.assertTrue((boolean)out.isFailed(), (String)"Should be failed");
        boolean b = exception instanceof NoXmlHeaderValidationException;
        Assertions.assertTrue((boolean)b, (String)"Exception should be correct type");
        Assertions.assertTrue((boolean)exception.getMessage().contains("headerToValidate"), (String)"Exception should mention missing header");
    }

    @Test
    public void testInvalideBytesMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>".getBytes());
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Test
    public void testInvalidBytesMessageInHeader() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:startHeaders", null, "headerToValidate", (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>".getBytes());
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Test
    public void testUseNotASharedSchema() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:useNotASharedSchema", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentUseNotASharedSchema() throws Exception {
        this.validEndpoint.expectedMessageCount(10);
        final CountDownLatch latch = new CountDownLatch(10);
        ExecutorService executor = Executors.newCachedThreadPool();
        for (int i = 0; i < 10; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ValidatorRouteTest.this.template.requestBody("direct:useNotASharedSchema", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>");
                    latch.countDown();
                }
            });
        }
        try {
            Assertions.assertTrue((boolean)latch.await(30000L, TimeUnit.MILLISECONDS));
            Assertions.assertEquals((long)0L, (long)latch.getCount(), (String)"Latch should be zero");
        }
        finally {
            executor.shutdown();
        }
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.finallyEndpoint = this.resolveMandatoryEndpoint("mock:finally", MockEndpoint.class);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("validator:org/apache/camel/component/validator/schema.xsd")).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid")).doFinally().to("mock:finally")).end();
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:startHeaders").doTry().to("validator:org/apache/camel/component/validator/schema.xsd?headerName=headerToValidate")).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid")).doFinally().to("mock:finally")).end();
                ((RouteDefinition)this.from("direct:startNoHeaderException").to("validator:org/apache/camel/component/validator/schema.xsd?headerName=headerToValidate")).to("mock:valid");
                ((RouteDefinition)this.from("direct:startNullHeaderNoFail").to("validator:org/apache/camel/component/validator/schema.xsd?headerName=headerToValidate&failOnNullHeader=false")).to("mock:valid");
                ((RouteDefinition)this.from("direct:useNotASharedSchema").to("validator:org/apache/camel/component/validator/schema.xsd?useSharedSchema=false")).to("mock:valid");
            }
        };
    }
}

