/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.validator.DefaultLSResourceResolver;
import org.apache.camel.component.validator.ValidatorComponent;
import org.apache.camel.component.validator.ValidatorEndpoint;
import org.apache.camel.component.validator.ValidatorResourceResolverFactory;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.jndi.JndiBeanRepository;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class ValidatorResourceResolverFactoryTest
extends ContextTestSupport {
    private Context jndiContext;

    @Test
    public void testConfigurationOnEndpoint() throws Exception {
        this.jndiContext.unbind("validator");
        String directStart = "direct:start";
        String endpointUri = "validator:org/apache/camel/component/validator/xsds/person.xsd?resourceResolverFactory=#resourceResolverFactory";
        this.execute(directStart, endpointUri);
    }

    @Test
    public void testConfigurationOnComponent() throws Exception {
        ValidatorComponent validatorComponent = new ValidatorComponent();
        validatorComponent.setResourceResolverFactory((ValidatorResourceResolverFactory)new ResourceResolverFactoryImpl());
        this.jndiContext.bind("validator", (Object)validatorComponent);
        String directStart = "direct:startComponent";
        String endpointUri = "validator:org/apache/camel/component/validator/xsds/person.xsd";
        this.execute(directStart, endpointUri);
    }

    void execute(String directStart, String endpointUri) throws InterruptedException {
        MockEndpoint endEndpoint = this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        endEndpoint.expectedMessageCount(1);
        String body = "<p:person user=\"james\" xmlns:p=\"org.person\" xmlns:h=\"org.health.check.person\" xmlns:c=\"org.health.check.common\">\n  <p:firstName>James</p:firstName>\n  <p:lastName>Strachan</p:lastName>\n  <p:city>London</p:city>\n  <h:health>\n      <h:lastCheck>2011-12-23</h:lastCheck>\n      <h:status>OK</h:status>\n      <c:commonElement>          <c:element1/>          <c:element2/>      </c:commonElement>  </h:health>\n</p:person>";
        this.template.sendBody(directStart, (Object)"<p:person user=\"james\" xmlns:p=\"org.person\" xmlns:h=\"org.health.check.person\" xmlns:c=\"org.health.check.common\">\n  <p:firstName>James</p:firstName>\n  <p:lastName>Strachan</p:lastName>\n  <p:city>London</p:city>\n  <h:health>\n      <h:lastCheck>2011-12-23</h:lastCheck>\n      <h:status>OK</h:status>\n      <c:commonElement>          <c:element1/>          <c:element2/>      </c:commonElement>  </h:health>\n</p:person>");
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> this.resolveMandatoryEndpoint(endpointUri, ValidatorEndpoint.class) != null);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{endEndpoint});
        ValidatorEndpoint validatorEndpoint = this.resolveMandatoryEndpoint(endpointUri, ValidatorEndpoint.class);
        Assertions.assertNotNull((Object)validatorEndpoint);
        CustomResourceResolver resolver = (CustomResourceResolver)((Object)validatorEndpoint.getResourceResolver());
        Set<String> uris = resolver.getResolvedResourceUris();
        this.checkResourceUri(uris, "../type2.xsd");
        this.checkResourceUri(uris, "health/health.xsd");
        this.checkResourceUri(uris, "type1.xsd");
        this.checkResourceUri(uris, "common/common.xsd");
    }

    void checkResourceUri(Set<String> uris, String resourceUri) {
        Assertions.assertTrue((boolean)uris.contains(resourceUri), (String)("Missing resource uri " + resourceUri + " in resolved resource URI set"));
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        this.jndiContext = this.createJndiContext();
        this.jndiContext.bind("resourceResolverFactory", (Object)new ResourceResolverFactoryImpl());
        return new DefaultRegistry(new BeanRepository[]{new JndiBeanRepository(this.jndiContext)});
    }

    protected RouteBuilder[] createRouteBuilders() {
        return new RouteBuilder[]{new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setHeader("xsd_file", (Expression)new ConstantExpression("org/apache/camel/component/validator/xsds/person.xsd"))).recipientList((Expression)new SimpleExpression("validator:${header.xsd_file}?resourceResolverFactory=#resourceResolverFactory")).to("mock:end");
            }
        }, new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:startComponent").setHeader("xsd_file", (Expression)new ConstantExpression("org/apache/camel/component/validator/xsds/person.xsd"))).recipientList((Expression)new SimpleExpression("validator:${header.xsd_file}")).to("mock:end");
            }
        }};
    }

    static class ResourceResolverFactoryImpl
    implements ValidatorResourceResolverFactory {
        ResourceResolverFactoryImpl() {
        }

        public LSResourceResolver createResourceResolver(CamelContext camelContext, String rootResourceUri) {
            return new CustomResourceResolver(camelContext, rootResourceUri);
        }
    }

    static class CustomResourceResolver
    extends DefaultLSResourceResolver {
        private final Set<String> resolvedRsourceUris = new HashSet<String>();

        CustomResourceResolver(CamelContext camelContext, String resourceUri) {
            super(camelContext, resourceUri);
        }

        public Set<String> getResolvedResourceUris() {
            return this.resolvedRsourceUris;
        }

        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            LSInput result = super.resolveResource(type, namespaceURI, publicId, systemId, baseURI);
            this.resolvedRsourceUris.add(systemId);
            return result;
        }
    }
}

